/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.leaves;

import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import org.jetbrains.annotations.Nullable;

public class LeavesTypeRegistry
extends BlockTypeRegistry<LeavesType> {
    public static final LeavesTypeRegistry INSTANCE = new LeavesTypeRegistry();
    public static final LeavesType OAK_TYPE = new LeavesType(new ResourceLocation("oak"), Blocks.f_50050_);
    private final Map<ResourceLocation, ResourceLocation> specialLeavesToWood = new HashMap<ResourceLocation, ResourceLocation>();
    private final Map<LeavesType, WoodType> leavesToWood = new IdentityHashMap<LeavesType, WoodType>();

    @Deprecated(forRemoval=true)
    public static Collection<LeavesType> getTypes() {
        return INSTANCE.getValues();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static LeavesType getValue(ResourceLocation leavesTypeId) {
        return (LeavesType)INSTANCE.get(leavesTypeId);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static LeavesType getValue(String leavesTypeId) {
        return (LeavesType)INSTANCE.get(new ResourceLocation(leavesTypeId));
    }

    @Deprecated(forRemoval=true)
    public static LeavesType fromNBT(String name) {
        return (LeavesType)INSTANCE.getFromNBT(name);
    }

    public LeavesTypeRegistry() {
        super(LeavesType.class, "leaves_type");
    }

    @Override
    public LeavesType getDefaultType() {
        return OAK_TYPE;
    }

    @Nullable
    public WoodType getEquivalentWoodType(LeavesType leavesType) {
        return this.leavesToWood.get(leavesType);
    }

    @Override
    public Optional<LeavesType> detectTypeFromBlock(Block baseBlock, ResourceLocation blockId) {
        ResourceLocation id;
        String name = null;
        String path = blockId.m_135815_();
        if (path.endsWith("_leaves")) {
            name = path.substring(0, path.length() - "_leaves".length());
        } else if (path.startsWith("leaves_")) {
            name = path.substring("leaves_".length());
        }
        String namespace = blockId.m_135827_();
        if (name != null && !LeavesTypeRegistry.isBlacklisted(namespace, path) && baseBlock instanceof LeavesBlock && Objects.isNull(this.get(id = new ResourceLocation(namespace, name)))) {
            return Optional.of(new LeavesType(id, baseBlock));
        }
        return Optional.empty();
    }

    private static boolean isBlacklisted(String namespace, String path) {
        return namespace.equals("securitycraft") || namespace.equals("dynamic_trees") || namespace.matches("dynamictrees|dt\\w+") || path.contains("hanging");
    }

    @Override
    public void finalizeAndFreeze() {
        super.finalizeAndFreeze();
        for (LeavesType l : this.getValues()) {
            ResourceLocation leavesId = l.id;
            ResourceLocation id = this.specialLeavesToWood.getOrDefault(leavesId, leavesId);
            WoodType o = (WoodType)WoodTypeRegistry.INSTANCE.get(id);
            String path = id.m_135815_();
            String namespace = id.m_135827_();
            if (o == null) {
                for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                    if (!w.id.m_135815_().equals(path)) continue;
                    o = w;
                    break;
                }
            }
            if (o == null) {
                for (WoodType w : WoodTypeRegistry.INSTANCE.getValues()) {
                    if (!w.isVanilla() && !w.id.m_135827_().equals(namespace) || !path.endsWith(w.id.m_135815_())) continue;
                    o = w;
                }
            }
            if (o == null) continue;
            this.leavesToWood.put(l, o);
        }
    }

    public void addLeavesToWoodMapping(ResourceLocation leavesTypeId, ResourceLocation woodTypeId) {
        this.specialLeavesToWood.put(leavesTypeId, woodTypeId);
    }

    public void addLeavesToWoodMapping(String leavedId, String woodId) {
        this.addLeavesToWoodMapping(new ResourceLocation(leavedId), new ResourceLocation(woodId));
    }

    public void addLeavesToWoodMapping(String modId, String leavesTypeName, String woodTypeName) {
        this.addLeavesToWoodMapping(new ResourceLocation(modId, leavesTypeName), new ResourceLocation(modId, woodTypeName));
    }

    @Override
    public int priority() {
        return 99;
    }

    public LeavesType.Finder addSimpleFinder(ResourceLocation typeId) {
        LeavesType.Finder finder = new LeavesType.Finder(typeId);
        this.addFinder(finder);
        return finder;
    }

    public LeavesType.Finder addSimpleFinder(String typeId) {
        return this.addSimpleFinder(new ResourceLocation(typeId));
    }

    public LeavesType.Finder addSimpleFinder(String namespace, String name) {
        return this.addSimpleFinder(new ResourceLocation(namespace, name));
    }
}

