/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.cursee.longer_following_time;

import com.cursee.monolib.platform.Services;
import com.cursee.monolib.util.toml.Toml;
import com.cursee.monolib.util.toml.TomlWriter;
import fabric.com.cursee.longer_following_time.Constants;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class LFTConfig
implements IMixinConfigPlugin {
    public static final String ADDED_SECONDS = "addedSeconds";
    public static long addedSeconds = 4L;
    public static final Map<String, Object> defaults = new HashMap<String, Object>();

    public void onLoad(String mixinPackage) {
        defaults.put(ADDED_SECONDS, addedSeconds);
        File configDir = new File(Services.PLATFORM.getGameDirectory() + File.separator + "config");
        if (!configDir.isDirectory()) {
            configDir.mkdir();
        }
        File configFile = new File(configDir + File.separator + "longer_following_time.toml");
        LFTConfig.handle(configFile);
    }

    private static void handle(File file) {
        if (!file.isFile()) {
            LFTConfig.createConfigurationFile(file);
        } else {
            LFTConfig.loadConfigurationFile(file);
        }
    }

    private static void createConfigurationFile(File file) {
        try {
            TomlWriter writer = new TomlWriter();
            writer.write(defaults, file);
        }
        catch (IOException exception) {
            Constants.LOG.error("Fatal error occurred while attempting to write longer_following_time.toml");
            Constants.LOG.error("Did another process delete the config directory during writing?");
            Constants.LOG.error(exception.getMessage());
        }
    }

    private static void loadConfigurationFile(File file) {
        try {
            Toml toml = new Toml().read(file);
            addedSeconds = toml.getLong(ADDED_SECONDS);
        }
        catch (IllegalStateException exception) {
            Constants.LOG.error("Fatal error occurred while attempting to read longer_following_time.toml");
            Constants.LOG.error("Did another process delete the file during reading?");
            Constants.LOG.error(exception.getMessage());
        }
    }

    public String getRefMapperConfig() {
        return "";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

