/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import java.util.List;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class WelcomeMessageScreen
extends Screen {
    private final Screen lastScreen;
    private final Component text;
    @Nullable
    private final Component url;
    private final Runnable onTurnOff;
    private int ticksUntilEnable;
    private MultiLineLabel message = MultiLineLabel.f_94331_;
    private MultiLineLabel suggestions = MultiLineLabel.f_94331_;
    private Button exitButton;
    private Button disaleButton;
    private static final Component OF_TEXT = Component.m_237115_((String)"gui.supplementaries.optifine.message");
    private static final Component OF_URL = Component.m_237115_((String)"gui.supplementaries.optifine.suggestions").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GOLD).m_131157_(ChatFormatting.UNDERLINE).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://optifine.alternatives.lambdaurora.dev/")));
    private static final Component OF_TITLE = Component.m_237115_((String)"gui.supplementaries.optifine.title").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.BOLD);
    private static final Component AM_TEXT = Component.m_237115_((String)"gui.supplementaries.amendments.message");
    private static final Component AM_URL = Component.m_237115_((String)"gui.supplementaries.amendments.suggestions").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.GREEN).m_131157_(ChatFormatting.UNDERLINE).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://legacy.curseforge.com/minecraft/mc-mods/amendments")));
    private static final Component AM_TITLE = Component.m_237115_((String)"gui.supplementaries.amendments.title").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD);
    private static final Component IM_TITLE = Component.m_237115_((String)"gui.supplementaries.incompatible_mods.title").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD);
    private static final List<String> MODS_WITH_KNOWN_ISSUES = List.of("wwfix");
    private static final String IM_LIST = MODS_WITH_KNOWN_ISSUES.stream().filter(PlatHelper::isModLoaded).collect(Collectors.joining(", "));

    public WelcomeMessageScreen(Screen screen, int ticksUntilEnable, Component title, Component text, @Nullable Component url, Runnable onTurnOff) {
        super(title);
        this.lastScreen = screen;
        this.ticksUntilEnable = ticksUntilEnable;
        this.text = text;
        this.url = url;
        this.onTurnOff = onTurnOff;
    }

    public Component m_142562_() {
        return CommonComponents.m_267603_((Component[])new Component[]{super.m_142562_(), this.text});
    }

    protected void m_7856_() {
        super.m_7856_();
        this.exitButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130659_, pressed -> Minecraft.m_91087_().m_91152_(this.lastScreen)).m_252987_(this.f_96543_ / 2 + 5, this.f_96544_ * 5 / 6, 150, 20).m_253136_());
        this.exitButton.f_93623_ = false;
        this.disaleButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.supplementaries.welcome_screen.turn_off"), pressed -> {
            Minecraft.m_91087_().m_91152_(this.lastScreen);
            this.onTurnOff.run();
        }).m_252987_(this.f_96543_ / 2 - 155, this.f_96544_ * 5 / 6, 150, 20).m_253136_());
        this.disaleButton.f_93623_ = false;
        this.message = MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)this.text, (int)(this.f_96543_ - 50));
        this.suggestions = this.url == null ? MultiLineLabel.f_94331_ : MultiLineLabel.m_94341_((Font)this.f_96547_, (FormattedText)this.url, (int)(this.f_96543_ - 50));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 30, 0xFFFFFF);
        this.message.m_6276_(graphics, this.f_96543_ / 2, 55);
        this.suggestions.m_6276_(graphics, this.f_96543_ / 2, 180);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.exitButton.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void m_86600_() {
        super.m_86600_();
        if (--this.ticksUntilEnable <= 0) {
            this.exitButton.f_93623_ = true;
            this.disaleButton.f_93623_ = true;
        }
    }

    public boolean m_6913_() {
        return this.ticksUntilEnable <= 0;
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.lastScreen);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pMouseY > 180.0 && pMouseY < 190.0 && this.url != null) {
            Style style = this.getClickedComponentStyleAt((int)pMouseX);
            if (this.url != null && style != null && style.m_131182_() != null && style.m_131182_().m_130622_() == ClickEvent.Action.OPEN_URL) {
                this.m_5561_(style);
                return false;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    @Nullable
    private Style getClickedComponentStyleAt(int xPos) {
        int wid = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.url);
        int left = this.f_96543_ / 2 - wid / 2;
        int right = this.f_96543_ / 2 + wid / 2;
        return xPos >= left && xPos <= right ? Minecraft.m_91087_().f_91062_.m_92865_().m_92386_((FormattedText)this.url, xPos - left) : null;
    }

    public static WelcomeMessageScreen createOptifine(Screen screen) {
        return new WelcomeMessageScreen(screen, 200, OF_TITLE, OF_TEXT, OF_URL, () -> SuppPlatformStuff.disableOFWarn(true));
    }

    public static WelcomeMessageScreen createAmendments(Screen screen) {
        return new WelcomeMessageScreen(screen, 100, AM_TITLE, AM_TEXT, AM_URL, SuppPlatformStuff::disableAMWarn);
    }

    public static WelcomeMessageScreen createIncompatibleMods(Screen screen) {
        return new WelcomeMessageScreen(screen, 60, IM_TITLE, (Component)Component.m_237110_((String)"gui.supplementaries.incompatible_mods.message", (Object[])new Object[]{Component.m_237113_((String)IM_LIST).m_130940_(ChatFormatting.RED)}), null, SuppPlatformStuff::disableIMWarn);
    }

    public static boolean hasIncompat() {
        for (String s : MODS_WITH_KNOWN_ISSUES) {
            if (!PlatHelper.isModLoaded((String)s)) continue;
            return true;
        }
        return false;
    }
}

