/*
 * Decompiled with CFR 0.152.
 */
package com.zv;

import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ServerState
extends SavedData {
    public ConcurrentHashMap<BlockPos, Boolean> pyramidLocations = new ConcurrentHashMap();

    public static ServerState get(Entity entity) {
        return ServerState.get(entity.m_20194_());
    }

    public static ServerState get(LevelAccessor world) {
        return ServerState.get(world.m_7654_());
    }

    public static ServerState get(MinecraftServer server) {
        DimensionDataStorage persistentStateManager = server.m_129880_(Level.f_46428_).m_8895_();
        ServerState serverState = (ServerState)persistentStateManager.m_164861_(ServerState::createFromNbt, ServerState::new, "zombie_variants");
        serverState.m_77762_();
        return serverState;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        for (BlockPos pos : this.pyramidLocations.keySet()) {
            CompoundTag compound = new CompoundTag();
            compound.m_128356_("pos", pos.m_121878_());
            compound.m_128379_("hasPyramid", this.pyramidLocations.get(pos).booleanValue());
            list.add((Object)compound);
        }
        nbt.m_128365_("pyramidLocations", (Tag)list);
        return nbt;
    }

    public static ServerState createFromNbt(CompoundTag tag) {
        ServerState state = new ServerState();
        if (tag.m_128425_("pyramidLocations", 9)) {
            ListTag list = tag.m_128437_("pyramidLocations", 10);
            for (Tag element : list) {
                CompoundTag compound = (CompoundTag)element;
                BlockPos pos = BlockPos.m_122022_((long)compound.m_128454_("pos"));
                boolean hasPyramid = compound.m_128471_("hasPyramid");
                state.pyramidLocations.put(pos, hasPyramid);
            }
        }
        return state;
    }
}

