/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.reflection;

import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionUtil {
    public static boolean hasMethodOverride(Class<?> clazz, Class<?> superclass, boolean fallbackResult, String methodName, Class<?> ... methodArgs) {
        while (clazz != null && clazz != superclass && superclass.isAssignableFrom(clazz)) {
            try {
                clazz.getDeclaredMethod(methodName, methodArgs);
                return true;
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
            catch (NoClassDefFoundError | RuntimeException error) {
                Logger logger = LogManager.getLogger((String)"Radium Class Analysis");
                logger.warn("Radium Class Analysis Error: Class " + clazz.getName() + " cannot be analysed, because getting declared methods crashes with " + error.getClass().getSimpleName() + ": " + error.getMessage() + ". This is usually caused by modded entities declaring methods that have a return type or parameter type that is annotated with @OnlyIn(Dist.CLIENT). Loading the type is not possible, because it only exists in the CLIENT environment. The recommended fix is to annotate the method with this argument or return type with the same annotation. Lithium handles this error by assuming the class cannot be included in some optimizations.");
                return fallbackResult;
            }
            catch (Throwable e) {
                String crashedClass = clazz.getName();
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)"Radium Class Analysis");
                CrashReportCategory crashReportSection = crashReport.m_127514_(e.getClass().toString() + " when getting declared methods.");
                crashReportSection.m_128159_("Analyzed class", (Object)crashedClass);
                crashReportSection.m_128159_("Analyzed method name", (Object)methodName);
                crashReportSection.m_128159_("Analyzed method args", methodArgs);
                throw new ReportedException(crashReport);
            }
        }
        return false;
    }
}

