/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.util.inventory_comparator_tracking;

import me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import me.jellysquid.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import me.jellysquid.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracking;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntity.class})
public class BlockEntityMixin
implements ComparatorTracker {
    @Shadow
    @Nullable
    protected Level f_58857_;
    @Shadow
    @Final
    protected BlockPos f_58858_;
    private static final byte UNKNOWN = -1;
    private static final byte COMPARATOR_PRESENT = 1;
    private static final byte COMPARATOR_ABSENT = 0;
    byte hasComparators;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(BlockEntityType<?> type, BlockPos pos, BlockState state, CallbackInfo ci) {
        this.hasComparators = (byte)-1;
    }

    @Override
    public void onComparatorAdded(Direction direction, int offset) {
        byte hasComparators = this.hasComparators;
        if (direction.m_122434_() != Direction.Axis.Y && hasComparators != 1 && offset >= 1 && offset <= 2) {
            this.hasComparators = 1;
            BlockEntityMixin blockEntityMixin = this;
            if (blockEntityMixin instanceof InventoryChangeTracker) {
                InventoryChangeTracker inventoryChangeTracker = (InventoryChangeTracker)((Object)blockEntityMixin);
                inventoryChangeTracker.emitFirstComparatorAdded();
            }
        }
    }

    @Override
    public boolean hasAnyComparatorNearby() {
        if (this.hasComparators == -1) {
            this.hasComparators = ComparatorTracking.findNearbyComparators(this.f_58857_, this.f_58858_) ? (byte)1 : 0;
        }
        return this.hasComparators == 1;
    }

    @Inject(method={"markRemoved()V"}, at={@At(value="HEAD")})
    private void forgetNearbyComparators(CallbackInfo ci) {
        this.hasComparators = (byte)-1;
    }
}

