/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.xptome;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final Configuration CONFIG;
    public final ForgeConfigSpec.IntValue maxXP;
    public final ForgeConfigSpec.DoubleValue retrievalPercentage;
    public final ForgeConfigSpec.BooleanValue retriveUntilNextLevel;
    public final ForgeConfigSpec.BooleanValue retrieveXPOrbs;
    public final ForgeConfigSpec.BooleanValue storeUntilPreviousLevel;

    Configuration(ForgeConfigSpec.Builder builder) {
        this.maxXP = builder.comment("The maximum amount of XP points that the XP Tome can hold. The default value (1395) represents having 30 levels.").defineInRange("max_xp", 1395, 1, Integer.MAX_VALUE);
        this.retrievalPercentage = builder.comment(new String[]{"The percentage of XP that the book will give back, as a sort of cost of using it.", "Example: If this config value is set to 0.75, and an XP Tome has 100 XP stored, attempting to retrieve these 100 XP will give back 75 XP.", "Note: This will not be 100% accurate, as Minecraft's XP does not use decimals."}).defineInRange("retrieval_percentage", 1.0, 0.0, 1.0);
        this.retriveUntilNextLevel = builder.comment("Setting this to true will remove only as much XP from the book at a time as is needed for the player to reach their next level.").define("retrieve_until_next_level", false);
        this.retrieveXPOrbs = builder.comment("Setting this to true will remove XP from the book in XP orb form. This is useful if you want to use XP from the book for tools enchanted with Mending.").define("retrieve_xp_orbs", false);
        this.storeUntilPreviousLevel = builder.comment("Setting this to true will store only as much XP from the player's XP bar until reaching the previous level, meaning only one level at maximum will be added to the book's storage at a time.").define("store_until_previous_level", false);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Configuration::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG = (Configuration)specPair.getLeft();
    }
}

