/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.BoundroidWinchEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class BoundroidWinchModel
extends AdvancedEntityModel<BoundroidWinchEntity> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox coil;
    private final AdvancedModelBox lleg;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox cube_r2;
    private final AdvancedModelBox rarm;

    public BoundroidWinchModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 18.0f, 0.0f);
        this.body.setTextureOffset(20, 41).addBox(4.0f, -1.5f, -3.0f, 2.0f, 7.0f, 6.0f, 0.0f, false);
        this.body.setTextureOffset(36, 41).addBox(-6.0f, -1.5f, -3.0f, 2.0f, 7.0f, 6.0f, 0.0f, false);
        this.body.setTextureOffset(0, 0).addBox(-6.0f, -10.5f, -6.0f, 12.0f, 9.0f, 12.0f, 0.0f, false);
        this.coil = new AdvancedModelBox((AdvancedEntityModel)this);
        this.coil.setRotationPoint(0.0f, 2.5f, 0.0f);
        this.body.addChild((BasicModelPart)this.coil);
        this.coil.setTextureOffset(0, 21).addBox(-4.5f, -3.5f, -3.5f, 9.0f, 7.0f, 7.0f, 0.0f, false);
        this.coil.setTextureOffset(26, 29).addBox(-4.0f, -3.0f, -3.0f, 8.0f, 6.0f, 6.0f, 0.0f, false);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(5.0f, -7.5f, 5.0f);
        this.body.addChild((BasicModelPart)this.lleg);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(1.5f, -4.0f, 1.5f);
        this.lleg.addChild((BasicModelPart)this.cube_r1);
        this.setRotateAngle(this.cube_r1, 0.0f, -1.5708f, 0.0f);
        this.cube_r1.setTextureOffset(0, 35).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 10.0f, 5.0f, 0.0f, false);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larm.setRotationPoint(5.0f, -7.5f, -5.0f);
        this.body.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(0, 35).addBox(-1.0f, -9.0f, -4.0f, 5.0f, 10.0f, 5.0f, 0.0f, false);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(-5.0f, -7.5f, 5.0f);
        this.body.addChild((BasicModelPart)this.rleg);
        this.cube_r2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r2.setRotationPoint(-1.5f, -4.0f, 1.5f);
        this.rleg.addChild((BasicModelPart)this.cube_r2);
        this.setRotateAngle(this.cube_r2, 0.0f, 1.5708f, 0.0f);
        this.cube_r2.setTextureOffset(0, 35).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 10.0f, 5.0f, 0.0f, true);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarm.setRotationPoint(-5.0f, -7.5f, -5.0f);
        this.body.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(0, 35).addBox(-4.0f, -9.0f, -4.0f, 5.0f, 10.0f, 5.0f, 0.0f, true);
        this.updateDefaultPose();
    }

    public Vec3 getChainPosition(Vec3 offsetIn) {
        PoseStack armStack = new PoseStack();
        armStack.m_85836_();
        this.body.translateAndRotate(armStack);
        this.coil.translateAndRotate(armStack);
        Vector4f armOffsetVec = new Vector4f((float)offsetIn.f_82479_, (float)offsetIn.f_82480_, (float)offsetIn.f_82481_, 1.0f);
        armOffsetVec.mul((Matrix4fc)armStack.m_85850_().m_252922_());
        Vec3 vec3 = new Vec3((double)armOffsetVec.x(), (double)(-armOffsetVec.y()), (double)armOffsetVec.z());
        armStack.m_85849_();
        return vec3.m_82520_(0.0, 1.5, 0.0);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.coil, (Object)this.rarm, (Object)this.rleg, (Object)this.larm, (Object)this.lleg, (Object)this.cube_r1, (Object)this.cube_r2);
    }

    public void setupAnim(BoundroidWinchEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float chainLength = entity.getChainLength(partialTick);
        float bodyYaw = entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialTick;
        float walkSpeed = 0.8f;
        float walkDegree = 1.3f;
        float moveSideways = (float)(entity.m_20185_() - entity.f_19854_) * 3.0f;
        float moveForwards = (float)(entity.m_20189_() - entity.f_19856_) * 3.0f;
        float onGroundAmount = 1.0f - entity.getLatchProgress(partialTick);
        this.coil.rotateAngleX = (float)Math.toRadians(chainLength * 260.0f);
        this.body.rotateAngleX = (float)((double)this.body.rotateAngleX + (double)onGroundAmount * Math.PI);
        this.body.rotationPointY -= onGroundAmount * 11.0f;
        this.walk(this.larm, walkSpeed, walkDegree, true, 1.0f, 0.0f, ageInTicks, moveForwards);
        this.walk(this.rarm, walkSpeed, walkDegree, false, 1.0f, 0.0f, ageInTicks, moveForwards);
        this.walk(this.lleg, walkSpeed, walkDegree, true, -1.0f, 0.0f, ageInTicks, moveForwards);
        this.walk(this.rleg, walkSpeed, walkDegree, false, -1.0f, 0.0f, ageInTicks, moveForwards);
        this.flap(this.larm, walkSpeed, walkDegree, true, 1.0f, 0.0f, ageInTicks, moveSideways);
        this.flap(this.rarm, walkSpeed, walkDegree, false, 1.0f, 0.0f, ageInTicks, moveSideways);
        this.flap(this.lleg, walkSpeed, walkDegree, true, -1.0f, 0.0f, ageInTicks, moveSideways);
        this.flap(this.rleg, walkSpeed, walkDegree, false, -1.0f, 0.0f, ageInTicks, moveSideways);
    }
}

