/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.LanternfishEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class LanternfishModel
extends AdvancedEntityModel<LanternfishEntity> {
    private final AdvancedModelBox body;
    private final AdvancedModelBox tail;
    private final AdvancedModelBox rightfin;
    private final AdvancedModelBox leftfin;

    public LanternfishModel() {
        this.texWidth = 16;
        this.texHeight = 16;
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, 22.0f, -1.5f);
        this.body.setTextureOffset(2, 9).addBox(-1.0f, -1.0f, -2.5f, 2.0f, 2.0f, 5.0f, 0.0f, false);
        this.body.setTextureOffset(8, 3).addBox(0.0f, 1.0f, -1.25f, 0.0f, 2.0f, 4.0f, 0.0f, false);
        this.body.setTextureOffset(7, -1).addBox(0.0f, -2.5f, -1.0f, 0.0f, 2.0f, 3.0f, 0.0f, false);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, 0.0f, 2.5f);
        this.body.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(0, 3).addBox(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f, false);
        this.rightfin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rightfin.setRotationPoint(1.0f, 0.5f, -0.5f);
        this.body.addChild((BasicModelPart)this.rightfin);
        this.rightfin.setTextureOffset(0, 0).addBox(0.0f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, false);
        this.leftfin = new AdvancedModelBox((AdvancedEntityModel)this);
        this.leftfin.setRotationPoint(-1.0f, 0.5f, -0.5f);
        this.body.addChild((BasicModelPart)this.leftfin);
        this.leftfin.setTextureOffset(0, 0).addBox(-1.0f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, true);
        this.updateDefaultPose();
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.body, (Object)this.tail, (Object)this.rightfin, (Object)this.leftfin);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.body);
    }

    public void setupAnim(LanternfishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float swimSpeed = 0.9f;
        float swimDegree = 0.9f;
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float landProgress = entity.getLandProgress(partialTick);
        float pitchAmount = entity.getFishPitch(partialTick) / 57.295776f;
        this.progressRotationPrev(this.body, landProgress, 0.0f, 0.0f, (float)Math.toRadians(-90.0), 1.0f);
        this.walk(this.body, 0.1f, 0.05f, false, 0.0f, 0.0f, ageInTicks, 1.0f);
        this.bob(this.body, 0.1f, 0.3f, false, ageInTicks, 1.0f);
        this.swing(this.body, swimSpeed, swimDegree * 0.4f, false, 3.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.tail, swimSpeed, swimDegree * 0.8f, false, 2.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.rightfin, swimSpeed, swimDegree * 1.1f, true, 0.0f, 0.4f, limbSwing, limbSwingAmount);
        this.swing(this.leftfin, swimSpeed, swimDegree * 1.1f, false, 0.0f, 0.4f, limbSwing, limbSwingAmount);
        this.body.rotateAngleX += pitchAmount;
    }
}

