/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;
import net.minecraft.world.entity.Entity;

public class TubeWormModel
extends AdvancedEntityModel {
    private final AdvancedModelBox worm;

    public TubeWormModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.worm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.worm.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.worm.setTextureOffset(18, 23).addBox(-3.0f, -18.0f, -3.0f, 6.0f, 3.0f, 6.0f, 0.0f, false);
        this.worm.setTextureOffset(0, 0).addBox(-3.0f, -15.0f, -3.0f, 6.0f, 15.0f, 6.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.worm);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.worm);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
    }

    public void animateParticle(float age, float tuckAmount, float animationOffset, float yRot, float partialTicks) {
        this.resetToDefaultPose();
        float ageInTicks = age + partialTicks;
        float invTuckAmount = 1.0f - tuckAmount;
        float bob = (float)(1.0 + Math.sin(ageInTicks * 0.3f + animationOffset)) * 2.0f;
        this.worm.rotationPointY -= invTuckAmount * 10.0f - invTuckAmount * bob + 5.0f;
        this.worm.rotateAngleY = (float)((double)this.worm.rotateAngleY + Math.toRadians(yRot));
        this.walk(this.worm, 0.35f, 0.15f, false, animationOffset - 1.0f, 0.0f, ageInTicks, invTuckAmount);
        this.flap(this.worm, 0.35f, 0.2f, false, animationOffset + 2.0f, 0.0f, ageInTicks, invTuckAmount);
        this.worm.setScale(1.0f, Math.min(0.5f + invTuckAmount, 1.0f), 1.0f);
    }
}

