/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model.layered;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class DarknessArmorModel
extends HumanoidModel {
    public ModelPart rTail1;
    public ModelPart rTail2;
    public ModelPart lTail1;
    public ModelPart lTail2;
    public ModelPart cape;
    public ModelPart capeTail;

    public DarknessArmorModel(ModelPart root) {
        super(root);
        this.rTail1 = root.m_171324_("head").m_171324_("rtail1");
        this.rTail2 = this.rTail1.m_171324_("rtail2");
        this.lTail1 = root.m_171324_("head").m_171324_("ltail1");
        this.lTail2 = this.lTail1.m_171324_("ltail2");
        this.cape = root.m_171324_("body").m_171324_("cape");
        this.capeTail = this.cape.m_171324_("capeTail");
    }

    public static LayerDefinition createArmorLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)deformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171597_("head");
        PartDefinition body = partdefinition.m_171597_("body");
        head.m_171599_("hood", CubeListBuilder.m_171558_().m_171514_(68, 112).m_171488_(-6.0f, -2.0f, -5.5f, 12.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rtail1 = head.m_171599_("rtail1", CubeListBuilder.m_171558_().m_171514_(104, 105).m_171488_(-2.5f, -2.75f, -1.0f, 5.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.5f, (float)-8.25f, (float)2.0f));
        rtail1.m_171599_("rtail2", CubeListBuilder.m_171558_().m_171514_(104, 108).m_171488_(0.0f, -2.0f, -1.5f, 0.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.25f, (float)5.5f));
        PartDefinition ltail2 = head.m_171599_("ltail1", CubeListBuilder.m_171558_().m_171514_(104, 105).m_171480_().m_171488_(-2.5f, -2.75f, -1.0f, 5.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.5f, (float)-8.25f, (float)2.0f));
        ltail2.m_171599_("ltail2", CubeListBuilder.m_171558_().m_171514_(104, 108).m_171480_().m_171488_(0.0f, -2.0f, -1.5f, 0.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.25f, (float)5.5f));
        body.m_171599_("gem", CubeListBuilder.m_171558_().m_171514_(57, 123).m_171488_(-1.5f, 1.0f, -3.5f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cape = body.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(30, 111).m_171488_(-7.0f, 0.5f, 1.0f, 14.0f, 0.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(5, 111).m_171488_(-5.0f, 0.0f, 0.0f, 10.0f, 1.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)3.0f));
        cape.m_171599_("capeTail", CubeListBuilder.m_171558_().m_171514_(-17, 94).m_171488_(-7.0f, 0.0f, -1.5f, 14.0f, 0.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.5f, (float)14.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public DarknessArmorModel withAnimations(LivingEntity entity) {
        float partialTick = Minecraft.m_91087_().m_91296_();
        float limbSwingAmount = entity.f_267362_.m_267711_(partialTick);
        float ageInTicks = (float)entity.f_19797_ + partialTick;
        float stillAmount = 1.0f - limbSwingAmount;
        float capeWaveIdle = (float)Math.toRadians(Math.sin(ageInTicks * 0.05f) * 10.0 + 5.0) * stillAmount;
        float capeTailWaveIdle = (float)Math.toRadians(Math.sin(ageInTicks * 0.05f - 1.0f) * 10.0) * stillAmount;
        float capeWaveWalk = (float)Math.toRadians(Math.sin(ageInTicks * 0.5f) * 15.0) * limbSwingAmount;
        float capeTailWaveWalk = (float)Math.toRadians(Math.sin(ageInTicks * 0.5f - 1.5f) * 10.0) * limbSwingAmount;
        float hornsStill = (float)Math.toRadians(Math.sin(ageInTicks * 0.1f + 1.0f) * 5.0 + 2.5) * stillAmount;
        float hornsWalk = (float)Math.toRadians(Math.cos(ageInTicks * 0.6f + 2.0f) * 8.0) * limbSwingAmount;
        float horns1Flap = (float)Math.toRadians(Math.cos(ageInTicks * 0.1f + 2.0f) * 10.0);
        float horns2Flap = (float)Math.toRadians(Math.cos(ageInTicks * 0.1f + 3.0f) * 20.0 - 10.0);
        this.cape.f_104203_ = -((float)((double)stillAmount * Math.toRadians(70.0))) + capeWaveIdle + capeWaveWalk;
        this.capeTail.f_104203_ = -((float)((double)stillAmount * Math.toRadians(-25.0))) + capeTailWaveIdle + capeTailWaveWalk;
        this.rTail1.f_104203_ = hornsStill + hornsWalk;
        this.lTail1.f_104203_ = hornsStill + hornsWalk;
        this.lTail1.f_104204_ = horns1Flap + (float)(Math.toRadians(-30.0) * (double)stillAmount);
        this.rTail1.f_104204_ = -horns1Flap + (float)(Math.toRadians(30.0) * (double)stillAmount);
        this.lTail2.f_104204_ = horns2Flap;
        this.rTail2.f_104204_ = -horns2Flap;
        return this;
    }
}

