/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.AbstractTrailParticle;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeRenderTypes;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PurpleWitchMagicParticle
extends AbstractTrailParticle {
    private static final ResourceLocation CENTER_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/purple_witch_magic.png");
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/trail.png");
    private final double xTarget;
    private final double yTarget;
    private final double zTarget;

    protected PurpleWitchMagicParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.f_107230_ = 1.0f;
        this.f_107219_ = false;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.xTarget = xSpeed;
        this.yTarget = ySpeed;
        this.zTarget = zSpeed;
        this.f_107225_ = 100 + this.f_107223_.m_188503_(20);
    }

    public int m_6355_(float partialTicks) {
        return 240;
    }

    @Override
    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Quaternionf quaternion;
        super.m_5744_(vertexConsumer, camera, partialTick);
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
            float f3 = Mth.m_14179_((float)partialTick, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(f3));
        }
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexconsumer = multibuffersource$buffersource.m_6299_(ACRenderTypes.m_110467_((ResourceLocation)this.getTexture()));
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = 0.3f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        float alpha = this.getAlpha();
        int j = 240;
        PoseStack posestack = new PoseStack();
        PoseStack.Pose posestack$pose = posestack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        vertexconsumer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_7421_(f8, f6).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexconsumer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_7421_(f8, f5).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexconsumer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_7421_(f7, f5).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexconsumer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_7421_(f7, f6).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        multibuffersource$buffersource.m_109911_();
    }

    @Override
    protected VertexConsumer getVetrexConsumer(MultiBufferSource.BufferSource multibuffersource$buffersource) {
        return multibuffersource$buffersource.m_6299_(ForgeRenderTypes.getUnlitTranslucent((ResourceLocation)this.getTrailTexture()));
    }

    public float getAlpha() {
        return Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
    }

    public ResourceLocation getTexture() {
        return CENTER_TEXTURE;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        Vec3 travelVec = new Vec3(this.xTarget - this.f_107212_, this.yTarget - this.f_107213_, this.zTarget - this.f_107214_);
        if (travelVec.m_82553_() > 1.0) {
            travelVec = travelVec.m_82541_();
            this.f_107215_ = this.f_107215_ * 0.5 + travelVec.f_82479_ * (double)0.15f + this.f_107223_.m_188583_() * (double)0.05f;
            this.f_107216_ = this.f_107216_ * 0.5 + travelVec.f_82480_ * (double)0.15f + this.f_107223_.m_188583_() * (double)0.05f;
            this.f_107217_ = this.f_107217_ * 0.5 + travelVec.f_82481_ * (double)0.15f + this.f_107223_.m_188583_() * (double)0.05f;
        } else {
            this.f_107215_ *= 0.4;
            this.f_107216_ *= 0.4;
            this.f_107217_ *= 0.4;
            this.f_107224_ = Math.min(this.f_107224_ + 3, this.f_107225_);
        }
        float fadeIn = 0.8f * Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
        float fadeOut = Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        this.trailA = fadeIn * fadeOut;
    }

    @Override
    public float getTrailHeight() {
        return 0.15f;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return 5;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PurpleWitchMagicParticle particle = new PurpleWitchMagicParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.trailR = 1.0f;
            particle.trailG = 0.0f;
            particle.trailB = 1.0f;
            return particle;
        }
    }
}

