/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.BoundroidWinchModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.living.BoundroidWinchEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BoundroidWinchRenderer
extends MobRenderer<BoundroidWinchEntity, BoundroidWinchModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/boundroid_winch.png");
    private static final ResourceLocation TEXTURE_GLOW = new ResourceLocation("alexscaves:textures/entity/boundroid_winch_glow.png");
    private static final ResourceLocation TEXTURE_CHAIN = new ResourceLocation("minecraft:textures/block/chain.png");
    public static final int MAX_CHAIN_SEGMENTS = 256;

    public BoundroidWinchRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new BoundroidWinchModel(), 0.3f);
        this.m_115326_(new LayerGlow());
    }

    protected void scale(BoundroidWinchEntity mob, PoseStack matrixStackIn, float partialTicks) {
    }

    public boolean shouldRender(BoundroidWinchEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Mob)entity, camera, x, y, z)) {
            return true;
        }
        Entity weapon = entity.getHead();
        if (weapon != null) {
            Vec3 vec3 = entity.m_20182_();
            Vec3 vec31 = weapon.m_20182_();
            return camera.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    protected void setupRotations(BoundroidWinchEntity entity, PoseStack poseStack, float ptich, float yaw, float partialTicks) {
        if (BoundroidWinchRenderer.m_194453_((LivingEntity)entity)) {
            poseStack.m_252880_(0.0f, entity.m_20206_() + 0.1f, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    public void render(BoundroidWinchEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, source, packedLight);
        Vec3 translateFrom = entity.m_20318_(partialTicks);
        Vec3 modelOffset = ((BoundroidWinchModel)this.f_115290_).getChainPosition(new Vec3(0.0, (double)0.1f, 0.0));
        Vec3 chainTo = entity.getChainTo(partialTicks).m_82546_(translateFrom);
        Vec3 chainFrom = entity.getChainFrom(partialTicks).m_82549_(modelOffset).m_82546_(translateFrom).m_82546_(chainTo);
        VertexConsumer chainBuffer = source.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_CHAIN));
        int overlayHurtEffect = BoundroidWinchRenderer.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, partialTicks));
        poseStack.m_85836_();
        poseStack.m_85837_(chainTo.f_82479_, chainTo.f_82480_, chainTo.f_82481_);
        BoundroidWinchRenderer.renderChain(chainFrom, poseStack, chainBuffer, packedLight, overlayHurtEffect);
        poseStack.m_85849_();
    }

    private double modifyVecAngle(double dimension) {
        float abs = (float)Math.abs(dimension);
        return Math.signum(dimension) * Mth.m_14008_((double)Math.pow(abs, 0.1), (double)(0.01 * (double)abs), (double)abs);
    }

    public ResourceLocation getTextureLocation(BoundroidWinchEntity entity) {
        return TEXTURE;
    }

    public static void renderChain(Vec3 to, PoseStack poseStack, VertexConsumer buffer, int packedLightIn, int overlayCoords) {
        double d = to.m_165924_();
        float rotY = (float)(Mth.m_14136_((double)to.f_82479_, (double)to.f_82481_) * 57.2957763671875);
        float rotX = (float)(-(Mth.m_14136_((double)to.f_82480_, (double)d) * 57.2957763671875)) - 90.0f;
        float chainWidth = 0.1875f;
        float chainOffset = chainWidth * -0.5f;
        float chainLength = (float)to.m_82553_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotY));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotX));
        poseStack.m_252880_(0.0f, -chainLength, 0.0f);
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        buffer.m_252986_(matrix4f, chainOffset, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, chainLength).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, chainWidth + chainOffset, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(chainWidth, chainLength).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, chainWidth + chainOffset, chainLength, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(chainWidth, 0.0f).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, chainOffset, chainLength, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        float pixelSkip = 0.15625f;
        buffer.m_252986_(matrix4f, 0.0f, pixelSkip, chainOffset).m_6122_(255, 255, 255, 255).m_7421_(chainWidth, chainLength + pixelSkip).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, pixelSkip, chainWidth + chainOffset).m_6122_(255, 255, 255, 255).m_7421_(chainWidth * 2.0f, chainLength + pixelSkip).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, chainLength + pixelSkip, chainWidth + chainOffset).m_6122_(255, 255, 255, 255).m_7421_(chainWidth * 2.0f, pixelSkip).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, 0.0f, chainLength + pixelSkip, chainOffset).m_6122_(255, 255, 255, 255).m_7421_(chainWidth, pixelSkip).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    class LayerGlow
    extends RenderLayer<BoundroidWinchEntity, BoundroidWinchModel> {
        public LayerGlow() {
            super((RenderLayerParent)BoundroidWinchRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, BoundroidWinchEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_GLOW));
            float alpha = (float)(1.0 + Math.sin(ageInTicks * 0.1f + 2.0f)) * 0.1f + 0.5f;
            ((BoundroidWinchModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
        }
    }
}

