/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.GrottoceratopsModel;
import com.github.alexmodguy.alexscaves.client.model.SubterranodonModel;
import com.github.alexmodguy.alexscaves.client.model.TremorsaurusModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.item.DinosaurSpiritEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DinosaurSpiritRenderer
extends EntityRenderer<DinosaurSpiritEntity> {
    private static final ResourceLocation SUBTERRANODON_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/subterranodon.png");
    private static final ResourceLocation TREMORSAURUS_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/tremorsaurus.png");
    private static final ResourceLocation GROTTOCERATOPS_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/grottoceratops.png");
    private static final SubterranodonModel SUBTERRANODON_MODEL = new SubterranodonModel();
    private static final TremorsaurusModel TREMORSAURUS_MODEL = new TremorsaurusModel();
    private static final GrottoceratopsModel GROTTOCERATOPS_MODEL = new GrottoceratopsModel();

    public DinosaurSpiritRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(DinosaurSpiritEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.5, 0.0);
        if (entityIn.getDinosaurType() == DinosaurSpiritEntity.DinosaurType.GROTTOCERATOPS) {
            Player player = entityIn.getUsingPlayer();
            if (player != null) {
                Vec3 playerPos = player.m_20318_(partialTicks);
                Vec3 dinoPos = entityIn.m_20318_(partialTicks);
                double d1 = playerPos.f_82481_ - dinoPos.f_82481_;
                double d2 = playerPos.f_82479_ - dinoPos.f_82479_;
                float f = -((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f;
                poseStack.m_252781_(Axis.f_252436_.m_252977_(-f));
            }
        } else {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityIn.m_5675_(partialTicks)));
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252495_.m_252977_(entityIn.m_5686_(partialTicks)));
        float ghostAlpha = entityIn.getFadeIn(partialTicks);
        switch (entityIn.getDinosaurType()) {
            case SUBTERRANODON: {
                boolean prevBaby = DinosaurSpiritRenderer.SUBTERRANODON_MODEL.f_102610_;
                DinosaurSpiritRenderer.SUBTERRANODON_MODEL.f_102610_ = false;
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getRedGhost(SUBTERRANODON_TEXTURE));
                SUBTERRANODON_MODEL.animateSpirit(entityIn, partialTicks);
                SUBTERRANODON_MODEL.m_7695_(poseStack, ivertexbuilder, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, ghostAlpha);
                DinosaurSpiritRenderer.SUBTERRANODON_MODEL.f_102610_ = prevBaby;
                break;
            }
            case GROTTOCERATOPS: {
                boolean prevBaby = DinosaurSpiritRenderer.GROTTOCERATOPS_MODEL.f_102610_;
                DinosaurSpiritRenderer.GROTTOCERATOPS_MODEL.f_102610_ = false;
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getRedGhost(GROTTOCERATOPS_TEXTURE));
                GROTTOCERATOPS_MODEL.animateSpirit(entityIn, partialTicks);
                GROTTOCERATOPS_MODEL.renderSpiritToBuffer(poseStack, ivertexbuilder, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, ghostAlpha);
                DinosaurSpiritRenderer.GROTTOCERATOPS_MODEL.f_102610_ = prevBaby;
                break;
            }
            case TREMORSAURUS: {
                boolean prevBaby = DinosaurSpiritRenderer.TREMORSAURUS_MODEL.f_102610_;
                DinosaurSpiritRenderer.TREMORSAURUS_MODEL.f_102610_ = false;
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(ACRenderTypes.getRedGhost(TREMORSAURUS_TEXTURE));
                TREMORSAURUS_MODEL.animateSpirit(entityIn, partialTicks);
                TREMORSAURUS_MODEL.renderSpiritToBuffer(poseStack, ivertexbuilder, 240, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, ghostAlpha);
                DinosaurSpiritRenderer.TREMORSAURUS_MODEL.f_102610_ = prevBaby;
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(DinosaurSpiritEntity entity) {
        return SUBTERRANODON_TEXTURE;
    }
}

