/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.GingerbreadManModel;
import com.github.alexmodguy.alexscaves.client.render.entity.layer.LicowitchPossessionLayer;
import com.github.alexmodguy.alexscaves.server.entity.living.GingerbreadManEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class GingerbreadManRenderer
extends MobRenderer<GingerbreadManEntity, GingerbreadManModel> {
    private static final ResourceLocation[] TEXTURES_FOR_VARIANT = new ResourceLocation[9];
    private static final ResourceLocation TEXTURE_ALEX = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_alex.png");
    private static final ResourceLocation TEXTURE_CARRO = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_carro.png");
    private static final ResourceLocation TEXTURE_DENO = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_deno.png");
    private static final ResourceLocation TEXTURE_GATETOH = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_gatetoh.png");
    private static final ResourceLocation TEXTURE_HOLIDAY = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_holiday.png");
    private static final ResourceLocation TEXTURE_PINKY = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_pinky.png");
    private static final ResourceLocation TEXTURE_PLUMMET = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_plummet.png");
    private static final ResourceLocation TEXTURE_VAKY = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_vaky.png");
    private static final ResourceLocation TEXTURE_BLANK = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_blank.png");
    private static final ResourceLocation TEXTURE_TEAM_OVERLAY = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_team_overlay.png");

    public GingerbreadManRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new GingerbreadManModel(), 0.25f);
        this.m_115326_((RenderLayer)new ItemLayer(renderManagerIn.m_234598_()));
        this.m_115326_(new TeamOverlayLayer());
        this.m_115326_(new LicowitchPossessionLayer(this));
    }

    public ResourceLocation getTextureLocation(GingerbreadManEntity entity) {
        if (entity.m_8077_()) {
            String name = entity.m_7755_().getString().toLowerCase();
            if (name.contains("alex")) {
                return TEXTURE_ALEX;
            }
            if (name.contains("carro")) {
                return TEXTURE_CARRO;
            }
            if (name.contains("deno")) {
                return TEXTURE_DENO;
            }
            if (name.contains("gatetoh")) {
                return TEXTURE_GATETOH;
            }
            if (name.contains("holiday")) {
                return TEXTURE_HOLIDAY;
            }
            if (name.contains("pinky")) {
                return TEXTURE_PINKY;
            }
            if (name.contains("plummet")) {
                return TEXTURE_PLUMMET;
            }
            if (name.contains("vaky")) {
                return TEXTURE_VAKY;
            }
        }
        return TEXTURES_FOR_VARIANT[Mth.m_14045_((int)entity.getVariant(), (int)0, (int)8)];
    }

    protected void setupRotations(GingerbreadManEntity entity, PoseStack poseStack, float bob, float yawIn, float partialTicks) {
        if (this.m_5936_((LivingEntity)entity)) {
            yawIn += (float)(Math.cos((double)entity.f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if (!entity.m_217003_(Pose.SLEEPING)) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yawIn));
        }
        if (entity.f_20919_ > 0) {
            float f = ((float)entity.f_20919_ + partialTicks - 1.0f) / 20.0f * 1.6f;
            if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                f = 1.0f;
            }
            poseStack.m_252781_(Axis.f_252529_.m_252977_(f * this.m_6441_((LivingEntity)entity)));
        } else if (entity.m_21209_()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - entity.m_146909_()));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(((float)entity.f_19797_ + partialTicks) * -75.0f));
        } else if (entity.m_217003_(Pose.SLEEPING)) {
            Direction direction = entity.m_21259_();
            float f1 = direction != null ? GingerbreadManRenderer.sleepDirectionToRotation(direction) : yawIn;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(f1));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(this.m_6441_((LivingEntity)entity)));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
        } else if (GingerbreadManRenderer.m_194453_((LivingEntity)entity)) {
            poseStack.m_252880_(0.0f, entity.m_20206_() + 0.1f, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    private static float sleepDirectionToRotation(Direction p_115329_) {
        switch (p_115329_) {
            case SOUTH: {
                return 90.0f;
            }
            case WEST: {
                return 0.0f;
            }
            case NORTH: {
                return 270.0f;
            }
            case EAST: {
                return 180.0f;
            }
        }
        return 0.0f;
    }

    static {
        for (int i = 0; i <= 8; ++i) {
            GingerbreadManRenderer.TEXTURES_FOR_VARIANT[i] = new ResourceLocation("alexscaves:textures/entity/gingerbread_man/gingerbread_man_" + i + ".png");
        }
    }

    private class ItemLayer
    extends ItemInHandLayer<GingerbreadManEntity, GingerbreadManModel> {
        private final ItemInHandRenderer witchItemInHandRenderer;

        private ItemLayer(ItemInHandRenderer itemInHandRenderer) {
            super((RenderLayerParent)GingerbreadManRenderer.this, itemInHandRenderer);
            this.witchItemInHandRenderer = itemInHandRenderer;
        }

        protected void m_117184_(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext displayContext, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
            if (!itemStack.m_41619_() && livingEntity instanceof GingerbreadManEntity) {
                GingerbreadManEntity gingerbreadMan = (GingerbreadManEntity)livingEntity;
                float partialTicks = Minecraft.m_91087_().getPartialTick();
                float carryItemProgress = gingerbreadMan.getCarryItemProgress(partialTicks);
                boolean flag = humanoidArm == HumanoidArm.LEFT;
                poseStack.m_85836_();
                ((GingerbreadManModel)this.m_117386_()).m_6002_(humanoidArm, poseStack);
                poseStack.m_252880_(0.2f * (flag ? 1.0f : -1.0f), -0.05f + 0.1f * carryItemProgress, -0.15f);
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-160.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(20.0f * carryItemProgress * (flag ? 1.0f : -1.0f)));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(carryItemProgress * 90.0f));
                poseStack.m_252880_(0.0f, 0.0f, -0.1f * carryItemProgress);
                this.witchItemInHandRenderer.m_269530_(livingEntity, itemStack, displayContext, flag, poseStack, multiBufferSource, packedLight);
                poseStack.m_85849_();
            }
        }
    }

    class TeamOverlayLayer
    extends RenderLayer<GingerbreadManEntity, GingerbreadManModel> {
        public TeamOverlayLayer() {
            super((RenderLayerParent)GingerbreadManRenderer.this);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, GingerbreadManEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entitylivingbaseIn.isOvenSpawned()) {
                VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_TEAM_OVERLAY));
                int color = entitylivingbaseIn.getGingerbreadTeamColor();
                float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
                float g = (float)((color & 0xFF00) >> 8) / 255.0f;
                float b = (float)((color & 0xFF) >> 0) / 255.0f;
                ((GingerbreadManModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder2, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), r, g, b, 1.0f);
            }
        }
    }
}

