/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.GumWormSegmentModel;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormSegmentEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class GumWormSegmentRenderer
extends EntityRenderer<GumWormSegmentEntity> {
    private static final ResourceLocation TEXTURE_0 = new ResourceLocation("alexscaves", "textures/entity/gum_worm_segment_0.png");
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("alexscaves", "textures/entity/gum_worm_segment_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("alexscaves", "textures/entity/gum_worm_segment_2.png");
    private static final ResourceLocation TEXTURE_CONNECTOR = new ResourceLocation("alexscaves", "textures/entity/gum_worm_connection.png");
    private static final GumWormSegmentModel MODEL = new GumWormSegmentModel();

    public GumWormSegmentRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public boolean shouldRender(GumWormSegmentEntity entity, Frustum camera, double x, double y, double z) {
        if (super.m_5523_((Entity)entity, camera, x, y, z)) {
            return true;
        }
        Entity nextWorm = entity.getFrontEntity();
        if (nextWorm != null) {
            Vec3 vec3 = entity.m_20182_();
            Vec3 vec31 = nextWorm.m_20182_();
            return camera.m_113029_(new AABB(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_));
        }
        return false;
    }

    public void render(GumWormSegmentEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        Entity frontAttachedEntity = entity.getFrontEntity();
        Entity backAttachedEntity = entity.getBackEntity();
        float yRotLerp = Mth.m_14179_((float)partialTicks, (float)entity.f_19859_, (float)entity.m_146908_());
        float xRotLerp = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.0, 0.0);
        poseStack.m_252781_(Axis.f_252392_.m_252977_(yRotLerp));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(xRotLerp + 180.0f));
        poseStack.m_85837_(0.0, -0.5, 0.0);
        MODEL.setGumVisible(frontAttachedEntity != null, backAttachedEntity != null);
        MODEL.setupAnim(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, 0.0f, 0.0f);
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        MODEL.m_7695_(poseStack, ivertexbuilder, packedLightIn, GumWormSegmentRenderer.getOverlayCoords(entity, 0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        poseStack.m_85849_();
        if (frontAttachedEntity != null) {
            Vec3 centeredHeight = new Vec3(0.0, (double)(entity.m_20206_() * 0.5f), 0.0);
            Vec3 from = new Vec3(0.0, 0.0, (double)-0.9f).m_82496_((float)Math.toRadians(180.0f - xRotLerp)).m_82524_(-((float)Math.toRadians(yRotLerp))).m_82549_(centeredHeight);
            Vec3 attachment = frontAttachedEntity.m_20318_(partialTicks).m_82520_(0.0, (double)(entity.m_20206_() * 0.5f), 0.0);
            float zBack = 0.0f;
            float yUp = 0.0f;
            float theirYRotLerp = Mth.m_14179_((float)partialTicks, (float)frontAttachedEntity.f_19859_, (float)frontAttachedEntity.m_146908_());
            float theirXRotLerp = frontAttachedEntity.m_5686_(partialTicks);
            if (frontAttachedEntity instanceof GumWormSegmentEntity) {
                zBack = -0.9f;
            } else if (frontAttachedEntity instanceof GumWormEntity) {
                zBack = -1.7f;
            }
            Vec3 to = attachment.m_82549_(new Vec3(0.0, (double)yUp, (double)zBack).m_82496_(-((float)Math.toRadians(theirXRotLerp))).m_82524_(-((float)Math.toRadians(theirYRotLerp)))).m_82546_(entity.m_20318_(partialTicks));
            VertexConsumer gumConsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_CONNECTOR));
            poseStack.m_85836_();
            poseStack.m_85837_(from.f_82479_, from.f_82480_, from.f_82481_);
            GumWormSegmentRenderer.renderGum(to.m_82546_(from), poseStack, gumConsumer, packedLightIn, GumWormSegmentRenderer.getOverlayCoords(entity, 0.0f));
            poseStack.m_85849_();
        }
    }

    public static void renderGum(Vec3 to, PoseStack poseStack, VertexConsumer gumConsumer, int packedLightIn, int overlayCoords) {
        double d = to.m_165924_();
        float rotY = (float)(Mth.m_14136_((double)to.f_82479_, (double)to.f_82481_) * 57.2957763671875);
        float rotX = (float)(-(Mth.m_14136_((double)to.f_82480_, (double)d) * 57.2957763671875)) - 90.0f;
        float length = (float)to.m_82553_();
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotY));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotX));
        poseStack.m_252880_(0.0f, -length, 0.0f);
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        gumConsumer.m_252986_(matrix4f, 0.0f, 0.0f, -0.5f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        gumConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.5f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        gumConsumer.m_252986_(matrix4f, 0.0f, length, 0.5f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        gumConsumer.m_252986_(matrix4f, 0.0f, length, -0.5f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }

    public static int getOverlayCoords(GumWormSegmentEntity segmentEntity, float f) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)f), (int)OverlayTexture.m_118096_((boolean)segmentEntity.renderHurtFlag));
    }

    public ResourceLocation getTextureLocation(GumWormSegmentEntity entity) {
        switch (entity.getIndex() % 3) {
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
        }
        return TEXTURE_0;
    }
}

