/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.model.RaycatModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.RaycatEntity;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RaycatRenderer
extends MobRenderer<RaycatEntity, RaycatModel>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/raycat.png");
    private static final ResourceLocation TEXTURE_BODY = new ResourceLocation("alexscaves:textures/entity/raycat_body.png");
    private static final ResourceLocation TEXTURE_EYES = new ResourceLocation("alexscaves:textures/entity/raycat_eyes.png");
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private boolean sepia;

    public RaycatRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new RaycatModel(), 0.4f);
        this.m_115326_(new LayerGlow());
    }

    @Nullable
    protected RenderType getRenderType(RaycatEntity raycatEntity, boolean normal, boolean translucent, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(raycatEntity);
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return this.sepia ? null : ((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get() != false ? ACRenderTypes.getRadiationGlow(resourcelocation) : ACRenderTypes.m_110473_((ResourceLocation)resourcelocation));
        }
        return outline ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    private static void shineOriginVertex(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(0, 255, 0, 255).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void shineLeftCornerVertex(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(0, 255, 0, 0).m_7421_(xOffset, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void shineRightCornerVertex(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(0, 255, 0, 0).m_7421_(xOffset + 1.0f, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public void render(RaycatEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        if (!this.sepia && ((Boolean)AlexsCaves.CLIENT_CONFIG.radiationGlowEffect.get()).booleanValue()) {
            PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.IRRADIATED_SHADER);
        }
        float absorbAmount = entityIn.getAbsorbAmount(partialTicks);
        Entity absorbTarget = entityIn.getAbsorbTarget();
        if (absorbAmount > 0.0f && entityIn.m_6084_() && absorbTarget != null) {
            Vec3 to = absorbTarget.m_20318_(partialTicks).m_82520_(0.0, (double)(absorbTarget.m_20206_() * 0.5f), 0.0);
            Vec3 toTranslate = to.m_82546_(entityIn.m_20318_(partialTicks).m_82520_(0.0, (double)(entityIn.m_20206_() * 0.5f), 0.0));
            float yRot = (float)Mth.m_14136_((double)toTranslate.f_82479_, (double)toTranslate.f_82481_) * 180.0f / (float)Math.PI;
            float xRot = -((float)(Mth.m_14136_((double)toTranslate.f_82480_, (double)toTranslate.m_165924_()) * 57.2957763671875));
            float length = (float)toTranslate.m_82553_() * absorbAmount;
            float width = absorbAmount * 0.8f;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, entityIn.m_20206_() * 0.5f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot - 90.0f));
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
            poseStack.m_252781_(Axis.f_252393_.m_252977_(90.0f));
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f1 = posestack$pose.m_252922_();
            Matrix3f matrix3f1 = posestack$pose.m_252943_();
            VertexConsumer lightConsumer = bufferIn.m_6299_(ACRenderTypes.getNucleeperLights());
            RaycatRenderer.shineOriginVertex(lightConsumer, matrix4f1, matrix3f1, 0.0f, 0.0f);
            RaycatRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            RaycatRenderer.shineRightCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            RaycatRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            poseStack.m_85849_();
            poseStack.m_85849_();
        }
        super.m_7392_((Mob)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(RaycatEntity entity) {
        return TEXTURE_BODY;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    class LayerGlow
    extends RenderLayer<RaycatEntity, RaycatModel> {
        public LayerGlow() {
            super((RenderLayerParent)RaycatRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, RaycatEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(RaycatRenderer.this.sepia ? ACRenderTypes.getBookWidget(TEXTURE, true) : RenderType.m_110458_((ResourceLocation)TEXTURE));
            ((RaycatModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder1, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(RaycatRenderer.this.sepia ? ACRenderTypes.getBookWidget(TEXTURE_EYES, true) : ACRenderTypes.getEyesAlphaEnabled(TEXTURE_EYES));
            ((RaycatModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder2, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

