/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.client.model.SubmarineModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.item.SubmarineEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SubmarineRenderer
extends EntityRenderer<SubmarineEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/submarine/submarine.png");
    private static final ResourceLocation TEXTURE_EXPOSED = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_exposed.png");
    private static final ResourceLocation TEXTURE_WEATHERED = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_weathered.png");
    private static final ResourceLocation TEXTURE_OXIDIZED = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_oxidized.png");
    private static final ResourceLocation TEXTURE_NEW = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_new.png");
    private static final ResourceLocation TEXTURE_LOW = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_low.png");
    private static final ResourceLocation TEXTURE_MEDIUM = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_medium.png");
    private static final ResourceLocation TEXTURE_HIGH = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_high.png");
    private static final ResourceLocation TEXTURE_CRITICAL = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_critical.png");
    private static final ResourceLocation TEXTURE_BUTTONS = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_buttons.png");
    private static final ResourceLocation TEXTURE_GLOW = new ResourceLocation("alexscaves:textures/entity/submarine/submarine_glow.png");
    private static SubmarineModel MODEL = new SubmarineModel();
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public SubmarineRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 1.0f;
    }

    public void render(SubmarineEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int lightIn) {
        if (!SubmarineRenderer.isFirstPersonFloodlightsMode(entity)) {
            SubmarineRenderer.renderSubmarine(entity, partialTicks, poseStack, source, lightIn, true);
            super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, source, lightIn);
        }
    }

    public static boolean isFirstPersonFloodlightsMode(SubmarineEntity entity) {
        Entity player = Minecraft.m_91087_().m_91288_();
        return player.m_20365_((Entity)entity) && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && entity.areLightsOn();
    }

    public static void renderSubFirstPerson(SubmarineEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource source) {
        SubmarineRenderer.renderSubmarine(entity, partialTicks, poseStack, source, LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_9236_(), (BlockPos)entity.m_20183_()), false);
    }

    public static void renderSubmarine(SubmarineEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource source, int lightIn, boolean maskWater) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float ageInTicks = (float)entity.f_19797_ + partialTicks;
        float submarineYaw = entity.m_5675_(partialTicks);
        float submarinePitch = entity.m_5686_(partialTicks);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 1.5, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - submarineYaw));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252495_.m_252977_(submarinePitch));
        poseStack.m_252880_(0.0f, 0.0f, 0.0f);
        if (entity.getWaterHeight() > 0.0f && entity.getWaterHeight() < 1.6f) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)(Math.sin(ageInTicks * 0.1f) * 0.5)));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)(Math.sin(ageInTicks * 0.1f + 1.3f) * 0.5)));
        }
        poseStack.m_85836_();
        MODEL.setupAnim(entity, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        for (Entity passenger : entity.m_20197_()) {
            if (passenger == player && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) continue;
            AlexsCaves.PROXY.releaseRenderingEntity(passenger.m_20148_());
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.65f, -0.75f);
            poseStack.m_252781_(Axis.f_252495_.m_252977_(180.0f));
            poseStack.m_252781_(Axis.f_252392_.m_252977_(360.0f - submarineYaw));
            SubmarineRenderer.renderPassenger(passenger, 0.0, 0.0, 0.0, 0.0f, partialTicks, poseStack, source, lightIn);
            poseStack.m_85849_();
            AlexsCaves.PROXY.blockRenderingEntity(passenger.m_20148_());
        }
        VertexConsumer textureBuffer = source.m_6299_(RenderType.m_110458_((ResourceLocation)SubmarineRenderer.getSubmarineBaseTexture(entity)));
        MODEL.m_7695_(poseStack, textureBuffer, lightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer damageBuffer = source.m_6299_(RenderType.m_110473_((ResourceLocation)SubmarineRenderer.getSubmarineDamageTexture(entity)));
        MODEL.m_7695_(poseStack, damageBuffer, lightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (entity.getDamageLevel() <= 3) {
            VertexConsumer buttonsBuffer = source.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_BUTTONS));
            MODEL.m_7695_(poseStack, buttonsBuffer, lightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, entity.getSonarFlashAmount(partialTicks));
            if (entity.areLightsOn() && entity.m_20160_()) {
                VertexConsumer glowBuffer = source.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE_GLOW));
                MODEL.m_7695_(poseStack, glowBuffer, lightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (maskWater) {
            VertexConsumer waterMask = source.m_6299_(ACRenderTypes.getSubmarineMask());
            MODEL.setupWaterMask(entity, partialTicks);
            MODEL.getWaterMask().render(poseStack, waterMask, lightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!SubmarineRenderer.isFirstPersonFloodlightsMode(entity) && entity.areLightsOn() && entity.m_20160_()) {
            Entity first = entity.m_146895_();
            float xRot = 0.0f;
            float yRot = 0.0f;
            if (first instanceof Player) {
                Player firstPlayer = (Player)first;
                float headYaw = firstPlayer.f_20886_ + (firstPlayer.m_6080_() - firstPlayer.f_20886_) * partialTicks;
                xRot = firstPlayer.m_5686_(partialTicks) + submarinePitch;
                yRot = Mth.m_14148_((float)submarineYaw, (float)headYaw, (float)60.0f);
            }
            float length = 4.5f;
            float width = 0.45f;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.75f, -2.4f);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(submarineYaw));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
            poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f - xRot));
            poseStack.m_85841_(3.0f, 1.0f, 1.0f);
            poseStack.m_252880_(0.0f, -1.0f, 0.0f);
            PoseStack.Pose posestack$pose = poseStack.m_85850_();
            Matrix4f matrix4f1 = posestack$pose.m_252922_();
            Matrix3f matrix3f1 = posestack$pose.m_252943_();
            VertexConsumer lightConsumer = source.m_6299_(ACRenderTypes.getSubmarineLights());
            SubmarineRenderer.shineOriginVertex(lightConsumer, matrix4f1, matrix3f1, 0.0f, 0.0f);
            SubmarineRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            SubmarineRenderer.shineRightCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            SubmarineRenderer.shineLeftCornerVertex(lightConsumer, matrix4f1, matrix3f1, length, width, 0.0f, 0.0f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private static ResourceLocation getSubmarineDamageTexture(SubmarineEntity entity) {
        switch (entity.getDamageLevel()) {
            case 0: {
                return TEXTURE_NEW;
            }
            case 1: {
                return TEXTURE_LOW;
            }
            case 2: {
                return TEXTURE_MEDIUM;
            }
            case 3: {
                return TEXTURE_HIGH;
            }
            case 4: {
                return TEXTURE_CRITICAL;
            }
        }
        return TEXTURE_NEW;
    }

    public static <E extends Entity> void renderPassenger(E entityIn, double x, double y, double z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
            try {
                render = manager.m_114382_(entityIn);
                if (render == null) break block4;
                try {
                    render.m_7392_(entityIn, yaw, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.m_127521_((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
                entityIn.m_7976_(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
                crashreportcategory1.m_128159_("Assigned renderer", (Object)render);
                crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }

    private static void shineOriginVertex(VertexConsumer p_114220_, Matrix4f p_114221_, Matrix3f p_114092_, float xOffset, float yOffset) {
        p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(xOffset + 0.5f, yOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void shineLeftCornerVertex(VertexConsumer p_114215_, Matrix4f p_114216_, Matrix3f p_114092_, float p_114217_, float p_114218_, float xOffset, float yOffset) {
        p_114215_.m_252986_(p_114216_, -HALF_SQRT_3 * p_114218_, p_114217_, 0.0f).m_6122_(200, 235, 255, 0).m_7421_(xOffset, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void shineRightCornerVertex(VertexConsumer p_114224_, Matrix4f p_114225_, Matrix3f p_114092_, float p_114226_, float p_114227_, float xOffset, float yOffset) {
        p_114224_.m_252986_(p_114225_, HALF_SQRT_3 * p_114227_, p_114226_, 0.0f).m_6122_(200, 235, 255, 0).m_7421_(xOffset + 1.0f, yOffset + 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(p_114092_, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static ResourceLocation getSubmarineBaseTexture(SubmarineEntity entity) {
        switch (entity.getOxidizationLevel()) {
            case 0: {
                return TEXTURE;
            }
            case 1: {
                return TEXTURE_EXPOSED;
            }
            case 2: {
                return TEXTURE_WEATHERED;
            }
            case 3: {
                return TEXTURE_OXIDIZED;
            }
        }
        return TEXTURE;
    }

    public ResourceLocation getTextureLocation(SubmarineEntity entity) {
        return TEXTURE;
    }
}

