/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.PrimalMagmaBlock;
import com.github.alexmodguy.alexscaves.server.entity.living.LuxtructosaurusEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FissurePrimalMagmaBlock
extends Block {
    public static final IntegerProperty REGEN_HEIGHT = IntegerProperty.m_61631_((String)"regen_height", (int)0, (int)4);

    public FissurePrimalMagmaBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283820_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60953_(state -> 5).m_60978_(0.5f).m_60922_((state, getter, pos, entityType) -> entityType.m_20672_()).m_60982_((state, getter, pos) -> true).m_60991_((state, getter, pos) -> true).m_60918_(ACSoundTypes.FLOOD_BASALT).m_60977_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)REGEN_HEIGHT, (Comparable)Integer.valueOf(0)));
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (!entity.m_20161_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(level.m_269111_().m_269047_(), 1.0f);
            entity.m_20254_(6);
        }
        super.m_141947_(level, blockPos, blockState, entity);
    }

    public void m_7892_(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        if (!(entity instanceof LuxtructosaurusEntity)) {
            entity.m_20256_(entity.m_20184_().m_82542_(0.9, 0.1, 0.9));
            entity.m_6469_(level.m_269111_().m_269047_(), 1.0f);
            entity.m_20254_(6);
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && !((entityCollisionContext = (EntityCollisionContext)context).m_193113_() instanceof LuxtructosaurusEntity)) {
            return entityCollisionContext.m_193113_() instanceof ItemEntity ? Shapes.m_83040_() : PrimalMagmaBlock.SINK_SHAPE;
        }
        return super.m_5939_(state, level, blockPos, context);
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos blockPos) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!PrimalMagmaBlock.isBossActive((Level)serverLevel)) {
            int regenHeight = (Integer)blockState.m_61143_((Property)REGEN_HEIGHT);
            for (int i = 0; i < regenHeight + 1; ++i) {
                BlockState regenState = ((Block)ACBlockRegistry.FLOOD_BASALT.get()).m_49966_();
                BlockPos regenPos = blockPos.m_6630_(i);
                ArrayList<BlockState> neighbors = new ArrayList<BlockState>();
                if (i != 0 && !serverLevel.m_8055_(regenPos).m_60795_()) continue;
                for (Direction direction : Direction.values()) {
                    BlockState offsetState = serverLevel.m_8055_(regenPos.m_121945_(direction));
                    if (!offsetState.m_204336_(ACTagRegistry.REGENERATES_AFTER_PRIMORDIAL_BOSS_FIGHT) || offsetState.m_60713_((Block)this)) continue;
                    neighbors.add(offsetState);
                }
                if (!neighbors.isEmpty()) {
                    regenState = neighbors.stream().anyMatch(state -> state.m_60713_(Blocks.f_50440_)) ? Blocks.f_50440_.m_49966_() : (neighbors.stream().anyMatch(state -> state.m_60713_(Blocks.f_152544_)) ? Blocks.f_152544_.m_49966_() : (neighbors.stream().anyMatch(state -> state.m_60713_(Blocks.f_50493_)) ? Blocks.f_50493_.m_49966_() : (BlockState)Util.m_214621_(neighbors, (RandomSource)randomSource)));
                } else {
                    BlockState lowestNonMagma = this.findNonMagmaBlockBeneath((Level)serverLevel, blockPos);
                    if (lowestNonMagma.m_204336_(ACTagRegistry.REGENERATES_AFTER_PRIMORDIAL_BOSS_FIGHT)) {
                        regenState = lowestNonMagma;
                    }
                }
                serverLevel.m_46597_(regenPos, regenState);
            }
            if (serverLevel.f_46441_.m_188503_(2) == 0) {
                serverLevel.m_247517_((Player)null, blockPos, (SoundEvent)ACSoundRegistry.PRIMAL_MAGMA_FISSURE_CLOSE.get(), SoundSource.BLOCKS);
            }
        }
    }

    private BlockState findNonMagmaBlockBeneath(Level level, BlockPos blockPos) {
        while (blockPos.m_123342_() > level.m_141937_() && level.m_8055_(blockPos).m_60713_((Block)this)) {
            blockPos = blockPos.m_7495_();
        }
        return level.m_8055_(blockPos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        BlockState newState = super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
        levelAccessor.m_186460_(blockPos, (Block)this, 2);
        return newState;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        Vec3 center = Vec3.m_82514_((Vec3i)pos, (double)1.0).m_82520_((double)(randomSource.m_188501_() - 0.5f), 0.0, (double)(randomSource.m_188501_() - 0.5f));
        Vec3 delta = new Vec3((double)(randomSource.m_188501_() - 0.5f), (double)(randomSource.m_188501_() - 0.5f), (double)(randomSource.m_188501_() - 0.5f));
        if (randomSource.m_188501_() <= 0.33f) {
            level.m_7106_((ParticleOptions)ACParticleRegistry.RED_VENT_SMOKE.get(), center.f_82479_, center.f_82480_, center.f_82481_, delta.f_82479_ * (double)0.3f, (double)0.15f, delta.f_82481_ * (double)0.3f);
        }
        if (randomSource.m_188501_() < 0.1f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, center.f_82479_, center.f_82480_, center.f_82481_, delta.f_82479_, (double)0.7f + delta.f_82480_, delta.f_82481_);
            level.m_7785_(center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + randomSource.m_188501_() * 0.2f, 0.75f + randomSource.m_188501_() * 0.25f, false);
        }
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)ACBlockRegistry.PRIMAL_MAGMA.get());
    }

    public boolean m_7357_(BlockState blockState, BlockGetter getter, BlockPos blockPos, PathComputationType computationType) {
        return false;
    }

    public boolean isBurning(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public BlockPathTypes getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, BlockPathTypes originalType) {
        return BlockPathTypes.DANGER_FIRE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{REGEN_HEIGHT});
    }
}

