/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.CorrodentEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class CorrodentAttackGoal
extends Goal {
    private CorrodentEntity entity;
    private boolean burrowing = false;
    private int burrowCheckTime = 0;
    private int evadeFor = 0;

    public CorrodentAttackGoal(CorrodentEntity entity) {
        this.entity = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() && this.entity.fleeLightFor <= 0;
    }

    public void m_8037_() {
        LivingEntity target = this.entity.m_5448_();
        if (target != null) {
            double dist = this.entity.m_20270_((Entity)target);
            float f = this.entity.m_20205_() + target.m_20205_();
            if (this.burrowCheckTime++ > 40 && this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.burrowCheckTime = 0;
                if (!this.burrowing) {
                    if (this.entity.m_20096_() && dist > (double)f && (!this.entity.canReach(target.m_20183_()) || dist > 20.0 || this.entity.m_217043_().m_188503_(20) == 0)) {
                        this.burrowing = true;
                        this.evadeFor = 60 + this.entity.m_217043_().m_188503_(40);
                    }
                } else if (dist < (double)(f + 1.0f) || this.entity.m_217043_().m_188503_(10) == 0) {
                    this.burrowing = false;
                    this.evadeFor = 0;
                }
            }
            if (this.evadeFor > 0) {
                Vec3 vec3;
                --this.evadeFor;
                this.burrowing = true;
                this.entity.setDigging(true);
                if (this.entity.m_21573_().m_26571_() && (vec3 = this.generateEvadePosition(target.m_20183_())) != null) {
                    this.entity.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
                }
            } else if (this.burrowing) {
                if (this.entity.m_20096_()) {
                    this.entity.setDigging(true);
                }
                this.entity.m_21573_().m_5624_((Entity)target, 2.0);
                if (!this.entity.m_5830_()) {
                    this.entity.setDigging(false);
                    this.burrowing = false;
                }
            } else {
                if (!this.entity.m_5830_()) {
                    this.entity.setDigging(false);
                } else {
                    this.entity.setDigging(true);
                    this.entity.m_20256_(this.entity.m_20184_().m_82520_(0.0, 0.1, 0.0));
                }
                this.entity.m_21573_().m_5624_((Entity)target, 1.5);
            }
            if (dist < (double)(f + 1.0f)) {
                this.tryAnimation(CorrodentEntity.ANIMATION_BITE);
            }
            if (this.entity.getAnimation() == CorrodentEntity.ANIMATION_BITE) {
                this.entity.setDigging(false);
                if (this.entity.getAnimationTick() == 8) {
                    this.checkAndDealDamage(target, 1.5f);
                    if (this.entity.m_217043_().m_188499_()) {
                        this.evadeFor = 60 + this.entity.m_217043_().m_188503_(40);
                    }
                }
            }
        }
    }

    private Vec3 generateEvadePosition(BlockPos around) {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 10; ++i) {
            check.m_122193_((Vec3i)around);
            check.m_122184_(this.entity.m_217043_().m_188503_(16) - 8, this.entity.m_217043_().m_188503_(16) - 8, this.entity.m_217043_().m_188503_(16) - 8);
            if (!this.entity.m_9236_().m_46749_((BlockPos)check) || check.m_123342_() < this.entity.m_9236_().m_141937_()) break;
            while (this.entity.m_9236_().m_46859_((BlockPos)check) && this.entity.m_9236_().m_46749_((BlockPos)check) && check.m_123342_() > this.entity.m_9236_().m_141937_() - 1) {
                check.m_122184_(0, -1, 0);
            }
            if (!CorrodentEntity.isSafeDig((BlockGetter)this.entity.m_9236_(), check.m_7949_()) || !this.entity.canReach((BlockPos)check)) continue;
            return Vec3.m_82512_((Vec3i)check.m_7949_());
        }
        return null;
    }

    private void checkAndDealDamage(LivingEntity target, float multiplier) {
        if (this.entity.m_142582_((Entity)target) && (double)this.entity.m_20270_((Entity)target) < (double)(this.entity.m_20205_() + target.m_20205_()) + 1.0) {
            float f = (float)this.entity.m_21051_(Attributes.f_22281_).m_22135_() * multiplier;
            target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.entity), f);
            target.m_147240_(0.2 + 0.3 * (double)multiplier, this.entity.m_20185_() - target.m_20185_(), this.entity.m_20189_() - target.m_20189_());
            Entity entity = target.m_20202_();
            if (entity != null) {
                entity.m_20256_(target.m_20184_());
                entity.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.entity), f * 0.5f);
            }
            this.burrowing = true;
        }
    }

    public void m_8041_() {
        this.burrowing = false;
        this.burrowCheckTime = 0;
        this.evadeFor = 0;
    }

    private boolean tryAnimation(Animation animation) {
        if (this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.entity.setAnimation(animation);
            this.entity.m_216990_((SoundEvent)ACSoundRegistry.CORRODENT_ATTACK.get());
            return true;
        }
        return false;
    }
}

