/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class GumWormDigRandomlyGoal
extends Goal {
    private GumWormEntity entity;
    private double x;
    private double y;
    private double z;
    private boolean surface = false;

    public GumWormDigRandomlyGoal(GumWormEntity worm) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = worm;
    }

    public boolean m_8036_() {
        if (this.entity.m_20160_() || this.entity.m_20159_()) {
            return false;
        }
        this.surface = this.entity.m_217043_().m_188503_(2) == 0;
        Vec3 target = this.generateAnyPosition(true);
        if (target == null && !this.surface) {
            target = this.generateAnyPosition(false);
        }
        if (target == null) {
            return false;
        }
        this.x = target.f_82479_;
        this.y = target.f_82480_;
        this.z = target.f_82481_;
        return true;
    }

    public void m_8056_() {
        this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
    }

    public boolean m_8045_() {
        return !this.entity.m_21573_().m_26571_() && !this.entity.m_21573_().m_26577_();
    }

    public void m_8041_() {
        this.surface = false;
    }

    private Vec3 generateAnyPosition(boolean favoredBlocksOnly) {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos checkBefore = new BlockPos.MutableBlockPos();
        LivingEntity target = this.entity.m_5448_();
        Object center = target == null ? this.entity : target;
        for (int i = 0; i < 20; ++i) {
            check.m_122193_((Vec3i)center.m_20183_());
            check.m_122184_(this.entity.m_217043_().m_188503_(64) - 32, this.entity.m_217043_().m_188503_(64) - 32, this.entity.m_217043_().m_188503_(64) - 32);
            checkBefore.m_122190_((Vec3i)check);
            if (check.m_123342_() < this.entity.m_9236_().m_141937_() || !this.entity.m_9236_().m_46749_((BlockPos)check)) break;
            if (this.surface) {
                while (!this.entity.m_9236_().m_46859_((BlockPos)check) && check.m_123342_() < this.entity.m_9236_().m_151558_()) {
                    checkBefore.m_122190_((Vec3i)check);
                    check.m_122184_(0, 1, 0);
                }
                if (!this.entity.m_9236_().m_46859_((BlockPos)check) || favoredBlocksOnly && !this.entity.m_9236_().m_8055_((BlockPos)checkBefore).m_204336_(ACTagRegistry.GUM_WORM_FAVORED_DIGGING)) continue;
                return Vec3.m_82512_((Vec3i)check.m_7949_().m_7495_());
            }
            while (this.entity.m_9236_().m_46859_((BlockPos)check) && check.m_123342_() > this.entity.m_9236_().m_141937_() - 1) {
                checkBefore.m_122190_((Vec3i)check);
                check.m_122184_(0, -1, 0);
            }
            while (check.m_123342_() < this.entity.m_9236_().m_141937_() + 1) {
                check.m_122184_(0, 1, 0);
            }
            if (!GumWormEntity.isSafeDig((BlockGetter)this.entity.m_9236_(), check.m_7949_()) || favoredBlocksOnly && !this.entity.m_9236_().m_8055_((BlockPos)checkBefore).m_204336_(ACTagRegistry.GUM_WORM_FAVORED_DIGGING)) continue;
            return Vec3.m_82512_((Vec3i)check.m_7949_());
        }
        return null;
    }
}

