/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.FallingTreeBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.living.RelicheirusEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.MovingBlockData;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RelicheirusPushTreesGoal
extends MoveToBlockGoal {
    private static final int MAXIMUM_BLOCKS_PUSHED = 300;
    public static final int MAX_TREE_SPREAD = 12;
    private RelicheirusEntity relicheirus;
    private boolean madeTreeEntity = false;

    public RelicheirusPushTreesGoal(RelicheirusEntity relicheirus, int range) {
        super((PathfinderMob)relicheirus, 1.0, range, 6);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        this.relicheirus = relicheirus;
    }

    public boolean m_8036_() {
        return this.relicheirus.getPushingTreesFor() > 0 && !this.relicheirus.m_6162_() && super.m_8036_();
    }

    public boolean m_8045_() {
        return super.m_8045_() && !this.madeTreeEntity;
    }

    protected int m_6099_(PathfinderMob mob) {
        return RelicheirusPushTreesGoal.m_186073_((int)(10 + this.relicheirus.m_217043_().m_188503_(20)));
    }

    public double m_8052_() {
        return 4.0;
    }

    protected boolean m_25625_() {
        BlockPos target = this.m_6669_();
        return target != null && this.relicheirus.m_20275_((float)target.m_123341_() + 0.5f, this.relicheirus.m_20186_(), (float)target.m_123343_() + 0.5f) < this.m_8052_();
    }

    protected BlockPos m_6669_() {
        return this.relicheirus.getStandAtTreePos(this.getBottomOfTree((LevelReader)this.relicheirus.m_9236_(), this.f_25602_));
    }

    public void m_8037_() {
        super.m_8037_();
        BlockPos target = this.m_6669_();
        if (target != null) {
            if (this.m_25625_()) {
                if (this.relicheirus.lockTreePosition(this.f_25602_)) {
                    if (this.relicheirus.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                        this.relicheirus.setPeckY(this.f_25602_.m_123342_());
                        this.relicheirus.setAnimation(RelicheirusEntity.ANIMATION_PUSH_TREE);
                    } else if (this.relicheirus.getAnimation() == RelicheirusEntity.ANIMATION_PUSH_TREE && this.relicheirus.getAnimationTick() >= 35 && !this.madeTreeEntity) {
                        this.madeTreeEntity = true;
                        this.relicheirus.m_216990_((SoundEvent)ACSoundRegistry.RELICHEIRUS_TOPPLE.get());
                        ArrayList<BlockPos> gathered = new ArrayList<BlockPos>();
                        this.gatherAttachedBlocks(this.f_25602_, this.f_25602_, gathered);
                        if (!gathered.isEmpty()) {
                            ArrayList<MovingBlockData> allData = new ArrayList<MovingBlockData>();
                            for (BlockPos pos : gathered) {
                                BlockState moveState = this.relicheirus.m_9236_().m_8055_(pos);
                                BlockEntity te = this.relicheirus.m_9236_().m_7702_(pos);
                                BlockPos offset = pos.m_121996_((Vec3i)this.f_25602_);
                                MovingBlockData data = new MovingBlockData(moveState, moveState.m_60808_((BlockGetter)this.relicheirus.m_9236_(), pos), offset, te == null ? null : te.m_187482_());
                                this.relicheirus.m_9236_().m_46747_(pos);
                                allData.add(data);
                            }
                            for (BlockPos pos : gathered) {
                                this.relicheirus.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                            }
                            FallingTreeBlockEntity fallingTree = (FallingTreeBlockEntity)((EntityType)ACEntityRegistry.FALLING_TREE_BLOCK.get()).m_20615_(this.relicheirus.m_9236_());
                            fallingTree.m_20219_(Vec3.m_82512_((Vec3i)this.f_25602_));
                            fallingTree.setAllBlockData(FallingTreeBlockEntity.createTagFromData(allData));
                            fallingTree.setPlacementCooldown(1);
                            Vec3 vec3 = Vec3.m_82512_((Vec3i)this.f_25602_).m_82546_(this.relicheirus.m_20182_());
                            float f = -((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
                            fallingTree.setFallDirection(Direction.m_122364_((double)f));
                            this.relicheirus.m_9236_().m_7967_((Entity)fallingTree);
                        }
                    }
                }
            } else if (this.relicheirus.m_21573_().m_26571_()) {
                Vec3 vec31 = Vec3.m_82512_((Vec3i)target);
                Vec3 vec32 = vec31.m_82546_(this.relicheirus.m_20182_());
                if (vec32.m_82553_() > 1.0) {
                    vec32 = vec32.m_82541_();
                }
                Vec3 delta = new Vec3(vec32.f_82479_ * (double)0.1f, 0.0, vec32.f_82481_ * (double)0.1f);
                this.relicheirus.m_20256_(this.relicheirus.m_20184_().m_82549_(delta));
            }
        }
    }

    protected void m_25624_() {
        BlockPos pos = this.m_6669_();
        this.f_25598_.m_21573_().m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, this.f_25599_);
    }

    public void m_8041_() {
        this.f_25602_ = BlockPos.f_121853_;
        this.madeTreeEntity = false;
        super.m_8041_();
    }

    private BlockPos getBottomOfTree(LevelReader worldIn, BlockPos pos) {
        while (pos.m_123342_() > worldIn.m_141937_() && (worldIn.m_8055_(pos).m_204336_(ACTagRegistry.RELICHEIRUS_KNOCKABLE_LEAVES) || worldIn.m_8055_(pos).m_60795_() || worldIn.m_8055_(pos).m_204336_(ACTagRegistry.RELICHEIRUS_KNOCKABLE_LOGS))) {
            pos = pos.m_7495_();
        }
        return pos;
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
        if (worldIn.m_8055_(pos).m_204336_(ACTagRegistry.RELICHEIRUS_KNOCKABLE_LOGS)) {
            BlockPos treeTop = new BlockPos((Vec3i)pos);
            while (worldIn.m_8055_(treeTop).m_204336_(ACTagRegistry.RELICHEIRUS_KNOCKABLE_LOGS) && treeTop.m_123342_() < worldIn.m_151558_()) {
                treeTop = treeTop.m_7494_();
            }
            if (worldIn.m_8055_(treeTop).m_204336_(ACTagRegistry.RELICHEIRUS_KNOCKABLE_LEAVES)) {
                return true;
            }
        }
        return false;
    }

    public void gatherAttachedBlocks(BlockPos origin, BlockPos pos, List<BlockPos> list) {
        if (list.size() < 300 && !list.contains(pos)) {
            list.add(pos);
            for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)pos.m_7918_(-1, -1, -1), (BlockPos)pos.m_7918_(1, 1, 1))) {
                if (blockpos1.equals((Object)pos) || !(pos.m_203198_((double)origin.m_123341_(), (double)pos.m_123342_(), (double)origin.m_123343_()) < 12.0) || !this.isTreePart(blockpos1)) continue;
                this.gatherAttachedBlocks(origin, blockpos1.m_7949_(), list);
            }
        }
    }

    public boolean isTreePart(BlockPos pos) {
        BlockState state = this.relicheirus.m_9236_().m_8055_(pos);
        if (state.m_60795_() || state.m_204336_(ACTagRegistry.UNMOVEABLE)) {
            return false;
        }
        return state.m_204336_(ACTagRegistry.RELICHEIRUS_KNOCKABLE_LOGS) || state.m_204336_(ACTagRegistry.RELICHEIRUS_KNOCKABLE_LEAVES);
    }
}

