/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.item;

import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACDamageTypes;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PlayMessages;

public class DinosaurSpiritEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_ID = SynchedEntityData.m_135353_(DinosaurSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DINOSAUR_TYPE = SynchedEntityData.m_135353_(DinosaurSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACKING_ENTITY_ID = SynchedEntityData.m_135353_(DinosaurSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DELAY_SPAWN = SynchedEntityData.m_135353_(DinosaurSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FADING = SynchedEntityData.m_135353_(DinosaurSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> USING_ABILITY = SynchedEntityData.m_135353_(DinosaurSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> ROTATE_OFFSET = SynchedEntityData.m_135353_(DinosaurSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> ENCHANTMENT_LEVEL = SynchedEntityData.m_135353_(DinosaurSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float fadeIn = 0.0f;
    private float prevFadeIn = 0.0f;
    private int duration = 0;
    private float abilityProgress = 0.0f;
    private float prevAbilityProgress = 0.0f;
    private int lSteps;
    private double lx;
    private double ly;
    private double lz;
    private double lxr;
    private double lxd;
    private double lyd;
    private double lzd;
    private boolean dealtDamage = false;

    public DinosaurSpiritEntity(EntityType entityType, Level level) {
        super(entityType, level);
    }

    public DinosaurSpiritEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType)ACEntityRegistry.BEHOLDER_EYE.get(), level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PLAYER_ID, Optional.empty());
        this.f_19804_.m_135372_(DINOSAUR_TYPE, (Object)0);
        this.f_19804_.m_135372_(ATTACKING_ENTITY_ID, (Object)-1);
        this.f_19804_.m_135372_(DELAY_SPAWN, (Object)0);
        this.f_19804_.m_135372_(FADING, (Object)false);
        this.f_19804_.m_135372_(USING_ABILITY, (Object)false);
        this.f_19804_.m_135372_(ENCHANTMENT_LEVEL, (Object)0);
        this.f_19804_.m_135372_(ROTATE_OFFSET, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        Player player = this.getUsingPlayer();
        this.prevFadeIn = this.fadeIn;
        this.prevAbilityProgress = this.abilityProgress;
        if (this.getDelaySpawn() > 0) {
            this.setDelaySpawn(this.getDelaySpawn() - 1);
            this.fadeIn = 0.0f;
            if (this.getDelaySpawn() == 0) {
                this.m_5496_((SoundEvent)ACSoundRegistry.EXTINCTION_SPEAR_SUMMON.get(), 1.0f, 1.0f);
            }
            return;
        }
        if (this.isFading() && this.fadeIn > 0.0f) {
            this.fadeIn -= 1.0f;
        }
        if (!this.isFading() && this.fadeIn < 10.0f) {
            this.fadeIn += 1.0f;
        }
        if (this.isUsingAbility() && this.abilityProgress < 5.0f) {
            this.abilityProgress += 1.0f;
        }
        if (!this.isUsingAbility() && this.abilityProgress > 0.0f) {
            this.abilityProgress -= 1.0f;
        }
        if (this.isFading() && this.fadeIn <= 0.0f) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
        if (player == null) {
            this.setFading(true);
        } else {
            switch (this.getDinosaurType()) {
                case SUBTERRANODON: {
                    this.tickSubterranodon(player);
                    break;
                }
                case GROTTOCERATOPS: {
                    this.tickGrottoceratops(player);
                    break;
                }
                case TREMORSAURUS: {
                    this.tickTremorsaurus(player);
                }
            }
        }
        if (this.m_9236_().f_46443_) {
            if (this.lSteps > 0) {
                double d5 = this.m_20185_() + (this.lx - this.m_20185_()) / (double)this.lSteps;
                double d6 = this.m_20186_() + (this.ly - this.m_20186_()) / (double)this.lSteps;
                double d7 = this.m_20189_() + (this.lz - this.m_20189_()) / (double)this.lSteps;
                this.m_146926_(this.m_146909_() + (float)(this.lxr - (double)this.m_146909_()) / (float)this.lSteps);
                --this.lSteps;
                this.m_6034_(d5, d6, d7);
            } else {
                this.m_20090_();
            }
        }
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int steps, boolean b) {
        this.lx = x;
        this.ly = y;
        this.lz = z;
        this.lxr = xr;
        this.lSteps = steps;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    public void m_6001_(double lerpX, double lerpY, double lerpZ) {
        this.lxd = lerpX;
        this.lyd = lerpY;
        this.lzd = lerpZ;
        this.m_20334_(this.lxd, this.lyd, this.lzd);
    }

    private void tickSubterranodon(Player player) {
        Entity target = this.getAttackingEntity();
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.03 + (double)(0.005f * (float)this.getEnchantmentLevel()), 0.0));
        if (target != null && this.duration < 40 + this.getEnchantmentLevel() * 5) {
            Vec3 targetMovePos = this.m_20182_().m_82492_(0.0, (double)target.m_20206_(), 0.0);
            target.m_20256_(Vec3.f_82478_);
            target.m_6034_(targetMovePos.f_82479_, targetMovePos.f_82480_, targetMovePos.f_82481_);
            ++this.duration;
        } else {
            this.setFading(true);
        }
    }

    private void tickGrottoceratops(Player player) {
        float rot = this.getRotateOffset() + (float)(player.f_19797_ * 5);
        Vec3 orbitBy = new Vec3(0.0, 1.0, 2.0).m_82524_((float)(-Math.toRadians(rot)));
        Vec3 orbitTarget = player.m_20182_().m_82549_(orbitBy).m_82546_(this.m_20182_());
        this.m_146926_(10.0f);
        this.m_20256_(orbitTarget.m_82490_(0.25));
        this.f_19794_ = true;
        if (!this.m_9236_().f_46443_ && !player.m_21211_().m_150930_((Item)ACItemRegistry.EXTINCTION_SPEAR.get())) {
            this.setFading(true);
        }
    }

    private void tickTremorsaurus(Player player) {
        Entity target = this.getAttackingEntity();
        if (target != null) {
            boolean inRange;
            this.f_19794_ = true;
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
            boolean bl = inRange = (double)this.m_20270_(target) < (double)target.m_20205_() + 3.5;
            if (!inRange) {
                Vec3 targetPos = target.m_20182_().m_82546_(this.m_20182_());
                if (targetPos.m_82553_() > 1.0) {
                    targetPos = targetPos.m_82541_();
                }
                this.m_20256_(targetPos.m_82490_((double)0.15f));
            }
            this.setUsingAbility(true);
            if (inRange && this.abilityProgress >= 5.0f) {
                if (!this.dealtDamage && target.m_6469_(ACDamageTypes.causeSpiritDinosaurDamage(this.m_9236_().m_9598_(), (Entity)player), (float)(3 + 2 * this.getEnchantmentLevel()))) {
                    this.dealtDamage = true;
                }
                this.setFading(true);
            }
        }
        if (this.duration++ > 20) {
            this.setFading(true);
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("UsingPlayerUUID")) {
            this.setPlayerUUID(tag.m_128342_("UsingPlayerUUID"));
        }
        this.setDinosaurTypeInt(tag.m_128451_("DinosaurType"));
    }

    protected void m_7380_(CompoundTag tag) {
        UUID uuid1 = this.getPlayerUUID();
        if (uuid1 != null) {
            tag.m_128362_("UsingPlayerUUID", uuid1);
        }
        tag.m_128405_("DinosaurType", this.getDinosaurTypeInt());
    }

    public void setPlayerUUID(UUID uuid) {
        this.f_19804_.m_135381_(PLAYER_ID, Optional.ofNullable(uuid));
    }

    public UUID getPlayerUUID() {
        return ((Optional)this.f_19804_.m_135370_(PLAYER_ID)).orElse(null);
    }

    public Player getUsingPlayer() {
        UUID id = this.getPlayerUUID();
        if (id == null) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            return this.m_9236_().m_46003_(id);
        }
        return this.m_9236_().m_7654_().m_6846_().m_11259_(id);
    }

    private int getDinosaurTypeInt() {
        return (Integer)this.f_19804_.m_135370_(DINOSAUR_TYPE);
    }

    private void setDinosaurTypeInt(int type) {
        this.f_19804_.m_135381_(DINOSAUR_TYPE, (Object)type);
    }

    public int getDelaySpawn() {
        return (Integer)this.f_19804_.m_135370_(DELAY_SPAWN);
    }

    public void setDelaySpawn(int type) {
        this.f_19804_.m_135381_(DELAY_SPAWN, (Object)type);
    }

    public int getEnchantmentLevel() {
        return (Integer)this.f_19804_.m_135370_(ENCHANTMENT_LEVEL);
    }

    public void setEnchantmentLevel(int type) {
        this.f_19804_.m_135381_(ENCHANTMENT_LEVEL, (Object)type);
    }

    public void setAttackingEntityId(int id) {
        this.f_19804_.m_135381_(ATTACKING_ENTITY_ID, (Object)id);
    }

    public Entity getAttackingEntity() {
        int id = (Integer)this.f_19804_.m_135370_(ATTACKING_ENTITY_ID);
        if (id == -1) {
            return null;
        }
        return this.m_9236_().m_6815_(id);
    }

    private float getRotateOffset() {
        return ((Float)this.f_19804_.m_135370_(ROTATE_OFFSET)).floatValue();
    }

    public void setRotateOffset(float rotateOffset) {
        this.f_19804_.m_135381_(ROTATE_OFFSET, (Object)Float.valueOf(rotateOffset));
    }

    public DinosaurType getDinosaurType() {
        return DinosaurType.values()[Mth.m_14045_((int)this.getDinosaurTypeInt(), (int)0, (int)DinosaurType.values().length)];
    }

    public void setDinosaurType(DinosaurType type) {
        this.f_19804_.m_135381_(DINOSAUR_TYPE, (Object)type.ordinal());
    }

    public boolean isFading() {
        return (Boolean)this.f_19804_.m_135370_(FADING);
    }

    public void setFading(boolean bool) {
        this.f_19804_.m_135381_(FADING, (Object)bool);
    }

    public boolean isUsingAbility() {
        return (Boolean)this.f_19804_.m_135370_(USING_ABILITY);
    }

    public void setUsingAbility(boolean bool) {
        this.f_19804_.m_135381_(USING_ABILITY, (Object)bool);
    }

    public float getFadeIn(float partialTicks) {
        return (this.prevFadeIn + (this.fadeIn - this.prevFadeIn) * partialTicks) * 0.1f;
    }

    public float getAbilityProgress(float partialTicks) {
        return (this.prevAbilityProgress + (this.abilityProgress - this.prevAbilityProgress) * partialTicks) * 0.2f;
    }

    public static enum DinosaurType {
        SUBTERRANODON,
        GROTTOCERATOPS,
        TREMORSAURUS;

    }
}

