/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.entity.ai.SemiAquaticPathNavigator;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class TrilocarisEntity
extends WaterAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(TrilocarisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(TrilocarisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float groundProgress;
    private float prevGroundProgress;
    private float biteProgress;
    private float prevBiteProgress;
    private int timeSwimming = 0;
    public boolean crawling;
    private int lastStepSoundTimestamp = -1;

    public TrilocarisEntity(EntityType<? extends WaterAnimal> type, Level level) {
        super(type, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 1.0f, 0.65f, false);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MeleeGoal());
        this.f_21345_.m_25352_(1, (Goal)new WanderGoal());
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    private static boolean isInCave(ServerLevelAccessor iServerWorld, BlockPos pos) {
        while (iServerWorld.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            pos = pos.m_7494_();
        }
        return !iServerWorld.m_45527_(pos) && pos.m_123342_() < iServerWorld.m_5736_();
    }

    public static boolean checkTrilocarisSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        FluidState fluidState = level.m_6425_(pos);
        return fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76186_() >= 8 && TrilocarisEntity.isInCave(level, pos);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new SemiAquaticPathNavigator((Mob)this, worldIn);
    }

    public int m_5792_() {
        return 4;
    }

    public boolean m_7296_(int sizeIn) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        return worldIn.m_6425_(pos.m_7495_()).m_76178_() && worldIn.m_6425_(pos).m_205070_(FluidTags.f_13131_) ? 10.0f : super.m_5610_(pos, worldIn);
    }

    protected void m_6229_(int air) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.15).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22276_, 10.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevGroundProgress = this.groundProgress;
        this.prevBiteProgress = this.biteProgress;
        if (this.m_20096_() && this.groundProgress < 5.0f) {
            this.groundProgress += 1.0f;
        }
        if (!this.m_20096_() && this.groundProgress > 0.0f) {
            this.groundProgress -= 1.0f;
        }
        if ((Integer)this.f_19804_.m_135370_(ATTACK_TICK) > 0) {
            this.f_19804_.m_135381_(ATTACK_TICK, (Object)((Integer)this.f_19804_.m_135370_(ATTACK_TICK) - 1));
            if (this.biteProgress < 5.0f) {
                this.biteProgress += 1.0f;
            }
        } else {
            if (this.biteProgress > 4.0f && this.m_5448_() != null && (double)this.m_20270_((Entity)this.m_5448_()) < 1.3) {
                this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
            }
            if (this.biteProgress > 0.0f) {
                this.biteProgress -= 1.0f;
            }
        }
        if (!this.m_9236_().f_46443_) {
            float delta = (float)this.m_20184_().m_165924_();
            if (this.crawling || !this.m_20072_()) {
                this.timeSwimming = 0;
                if (delta > 0.01f && this.f_19797_ - this.lastStepSoundTimestamp > 10) {
                    this.lastStepSoundTimestamp = this.f_19797_;
                    this.m_5496_((SoundEvent)ACSoundRegistry.TRILOCARIS_STEP.get(), 0.2f, 1.0f);
                }
            } else {
                ++this.timeSwimming;
            }
        }
    }

    public float getGroundProgress(float partialTick) {
        return (this.prevGroundProgress + (this.groundProgress - this.prevGroundProgress) * partialTick) * 0.2f;
    }

    public float getBiteProgress(float partialTick) {
        return (this.prevBiteProgress + (this.biteProgress - this.prevBiteProgress) * partialTick) * 0.2f;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20072_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            Vec3 delta = this.m_20184_();
            this.m_6478_(MoverType.SELF, delta);
            boolean pulldown = false;
            if (this.crawling) {
                delta = delta.m_82490_(0.8);
                delta = this.f_20899_ || this.f_19862_ ? delta.m_82520_(0.0, (double)0.1f, 0.0) : delta.m_82520_(0.0, (double)-0.05f, 0.0);
            }
            this.m_20256_(delta.m_82490_(0.8));
        } else {
            super.m_7023_(travelVector);
        }
    }

    @Nonnull
    public ItemStack m_28282_() {
        ItemStack stack = new ItemStack((ItemLike)ACItemRegistry.TRILOCARIS_BUCKET.get());
        if (this.m_8077_()) {
            stack.m_41714_(this.m_7770_());
        }
        return stack;
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compound);
    }

    @Nonnull
    protected InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean bucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)bucket);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double dist) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public boolean m_7327_(Entity entityIn) {
        this.f_19804_.m_135381_(ATTACK_TICK, (Object)5);
        return super.m_7327_(entityIn);
    }

    public void m_267651_(boolean flying) {
        float speedMod = !this.m_20096_() ? 4.0f : 16.0f;
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * speedMod, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.TRILOCARIS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.TRILOCARIS_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    private class MeleeGoal
    extends Goal {
        private int duration = 0;
        private int cooldown = 0;

        public MeleeGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return TrilocarisEntity.this.m_5448_() != null && TrilocarisEntity.this.m_5448_().m_6084_() && this.duration < 300;
        }

        public void m_8037_() {
            ++this.duration;
            LivingEntity target = TrilocarisEntity.this.m_5448_();
            if (target != null && target.m_6084_()) {
                if (target.m_20072_()) {
                    TrilocarisEntity.this.m_21573_().m_5624_((Entity)target, 1.0);
                }
                if (TrilocarisEntity.this.m_20270_((Entity)target) < 1.2f && this.cooldown == 0) {
                    TrilocarisEntity.this.m_7327_((Entity)target);
                    this.cooldown = 30;
                }
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
        }

        public void m_8041_() {
            this.duration = 0;
            this.cooldown = 0;
            TrilocarisEntity.this.m_6703_(null);
            TrilocarisEntity.this.m_6710_(null);
        }
    }

    private class WanderGoal
    extends Goal {
        private double x;
        private double y;
        private double z;
        private boolean isCrawling;

        public WanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (TrilocarisEntity.this.m_217043_().m_188503_(20) != 0 && TrilocarisEntity.this.crawling) {
                return false;
            }
            this.isCrawling = TrilocarisEntity.this.crawling ? TrilocarisEntity.this.m_217043_().m_188501_() < 0.5f : TrilocarisEntity.this.timeSwimming > 300 || TrilocarisEntity.this.m_217043_().m_188501_() < 0.15f;
            Vec3 target = this.getPosition();
            if (target == null) {
                return false;
            }
            this.x = target.f_82479_;
            this.y = target.f_82480_;
            this.z = target.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            double dist = TrilocarisEntity.this.m_20275_(this.x, this.y, this.z);
            return dist > 4.0;
        }

        public void m_8037_() {
            TrilocarisEntity.this.crawling = this.isCrawling;
            TrilocarisEntity.this.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
        }

        public BlockPos findWaterBlock() {
            BlockPos result = null;
            RandomSource random = TrilocarisEntity.this.m_217043_();
            int range = 10;
            for (int i = 0; i < 15; ++i) {
                BlockPos blockPos = TrilocarisEntity.this.m_20183_().m_7918_(random.m_188503_(range) - range / 2, random.m_188503_(range) - range / 2, random.m_188503_(range) - range / 2);
                if (!TrilocarisEntity.this.m_9236_().m_6425_(blockPos).m_205070_(FluidTags.f_13131_) || blockPos.m_123342_() <= TrilocarisEntity.this.m_9236_().m_141937_() + 1) continue;
                result = blockPos;
            }
            return result;
        }

        @Nullable
        protected Vec3 getPosition() {
            BlockPos water = this.findWaterBlock();
            if (TrilocarisEntity.this.m_20072_()) {
                if (water == null) {
                    return null;
                }
                if (this.isCrawling) {
                    while (TrilocarisEntity.this.m_9236_().m_6425_(water.m_7495_()).m_205070_(FluidTags.f_13131_) && water.m_123342_() > TrilocarisEntity.this.m_9236_().m_141937_() + 1) {
                        water = water.m_7495_();
                    }
                    water = water.m_7494_();
                }
                return Vec3.m_82512_((Vec3i)water);
            }
            return water == null ? DefaultRandomPos.m_148403_((PathfinderMob)TrilocarisEntity.this, (int)7, (int)3) : Vec3.m_82512_((Vec3i)water);
        }
    }
}

