/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.server.entity.ai.VerticalSwimmingMoveControl;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TripodfishEntity
extends WaterAnimal
implements Bucketable {
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.m_135353_(TripodfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(TripodfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDimensions STANDING_SIZE = EntityDimensions.m_20395_((float)0.95f, (float)1.5f);
    private float landProgress;
    private float prevLandProgress;
    private float fishPitch = 0.0f;
    private float prevFishPitch = 0.0f;
    private float standProgress;
    private float prevStandProgress;
    private boolean hasStandingSize = false;
    private int timeSwimming;
    private int timeStanding;
    private int navigateTypeLength = 300;
    private BlockPos hurtPos = null;
    private int fleeFor = 0;

    public TripodfishEntity(EntityType type, Level level) {
        super(type, level);
        this.f_21342_ = new MoveControl();
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STANDING, (Object)false);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AvoidHurtGoal());
        this.f_21345_.m_25352_(2, (Goal)new WanderGoal());
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && !TripodfishEntity.this.isStanding();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public boolean m_8036_() {
                return super.m_8036_() && !TripodfishEntity.this.isStanding();
            }
        });
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20072_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            Vec3 delta = this.m_20184_();
            if (this.m_5448_() == null && !this.isStanding()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
            this.m_6478_(MoverType.SELF, delta);
            this.m_20256_(delta.m_82490_(this.isStanding() ? (double)0.3f : 0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected void m_5625_(float f) {
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(STANDING);
    }

    public void setStanding(boolean standing) {
        this.f_19804_.m_135381_(STANDING, (Object)standing);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22276_, 8.0);
    }

    public int m_5792_() {
        return 2;
    }

    public boolean m_7296_(int sizeIn) {
        return false;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.isStanding() ? STANDING_SIZE.m_20388_(this.m_6134_()) : super.m_6972_(poseIn);
    }

    public void m_8119_() {
        boolean grounded;
        super.m_8119_();
        this.prevStandProgress = this.standProgress;
        this.prevFishPitch = this.fishPitch;
        this.prevLandProgress = this.landProgress;
        float pitchTarget = (float)this.m_20184_().f_82480_ * 3.0f;
        if (this.isStanding()) {
            if (this.standProgress < 10.0f) {
                this.standProgress += 1.0f;
            }
            if (!this.hasStandingSize) {
                this.hasStandingSize = true;
                this.m_6210_();
                this.navigateTypeLength = 400 + this.f_19796_.m_188503_(400);
            }
            ++this.timeStanding;
            this.timeSwimming = 0;
            pitchTarget = 0.0f;
            this.m_21573_().m_26573_();
            if (!this.m_20096_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0).m_82542_(0.5, 1.0, 0.5));
            }
        } else {
            if (this.standProgress > 0.0f) {
                this.standProgress -= 1.0f;
            }
            this.timeStanding = 0;
            ++this.timeSwimming;
            if (this.hasStandingSize) {
                this.hasStandingSize = false;
                double d = (float)((double)(this.m_20206_() * 0.35f) + this.m_20186_());
                this.m_6210_();
                this.m_6034_(this.m_20185_(), d, this.m_20189_());
                this.navigateTypeLength = 400 + this.f_19796_.m_188503_(400);
            }
        }
        this.fishPitch = Mth.m_14148_((float)this.fishPitch, (float)(Mth.m_14036_((float)pitchTarget, (float)-1.4f, (float)1.4f) * -57.295776f), (float)5.0f);
        boolean bl = grounded = !this.m_20072_();
        if (grounded && this.landProgress < 5.0f) {
            this.landProgress += 1.0f;
        }
        if (!grounded && this.landProgress > 0.0f) {
            this.landProgress -= 1.0f;
        }
        if (!this.m_20072_() && this.m_6084_() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_5496_((SoundEvent)ACSoundRegistry.TRIPODFISH_FLOP.get(), this.m_6121_(), this.m_6100_());
        }
        if (this.fleeFor > 0) {
            --this.fleeFor;
            if (this.fleeFor == 0) {
                this.hurtPos = null;
            }
        }
    }

    public float getFishPitch(float partialTick) {
        return this.prevFishPitch + (this.fishPitch - this.prevFishPitch) * partialTick;
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 6.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public static boolean checkTripodfishSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return level.m_6425_(pos).m_205070_(FluidTags.f_13131_) && pos.m_123342_() < level.m_5736_() - 30 && randomSource.m_188499_();
    }

    public float getLandProgress(float partialTicks) {
        return (this.prevLandProgress + (this.landProgress - this.prevLandProgress) * partialTicks) * 0.2f;
    }

    public float getStandProgress(float partialTicks) {
        return (this.prevStandProgress + (this.standProgress - this.prevStandProgress) * partialTicks) * 0.1f;
    }

    public boolean m_6469_(DamageSource damageSource, float damageValue) {
        boolean sup = super.m_6469_(damageSource, damageValue);
        if (sup) {
            this.fleeFor = 40 + this.f_19796_.m_188503_(40);
            this.hurtPos = this.m_20183_();
        }
        return sup;
    }

    private void doInitialPosing(LevelAccessor world) {
        BlockPos down = this.m_20183_();
        while (!world.m_6425_(down).m_76178_() && down.m_123342_() > world.m_141937_()) {
            down = down.m_7495_();
        }
        this.m_6034_((float)down.m_123341_() + 0.5f, down.m_123342_() + 1, (float)down.m_123343_() + 0.5f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (reason == MobSpawnType.NATURAL) {
            this.doInitialPosing((LevelAccessor)worldIn);
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public void m_6872_(@Nonnull ItemStack bucket) {
        if (this.m_8077_()) {
            bucket.m_41714_(this.m_7770_());
        }
        CompoundTag platTag = new CompoundTag();
        this.m_7380_(platTag);
        CompoundTag compound = bucket.m_41784_();
        compound.m_128365_("FishBucketTag", (Tag)platTag);
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double dist) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean sit) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)sit);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    public void m_142278_(@Nonnull CompoundTag compound) {
        if (compound.m_128441_("FishBucketTag")) {
            this.m_7378_(compound.m_128469_("FishBucketTag"));
        }
        this.m_20301_(2000);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)ACItemRegistry.TRIPODFISH_BUCKET.get());
    }

    @Nonnull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ACSoundRegistry.TRIPODFISH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ACSoundRegistry.TRIPODFISH_HURT.get();
    }

    public boolean m_6673_(DamageSource damageSource) {
        return damageSource.m_276093_(DamageTypes.f_268612_) || super.m_6673_(damageSource);
    }

    private class MoveControl
    extends VerticalSwimmingMoveControl {
        private MoveControl() {
            super((Mob)TripodfishEntity.this, 0.5f, 60.0f);
        }

        @Override
        public void m_8126_() {
            if (!TripodfishEntity.this.isStanding()) {
                super.m_8126_();
            }
        }
    }

    class AvoidHurtGoal
    extends Goal {
        private Vec3 fleeTarget = null;

        protected AvoidHurtGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return TripodfishEntity.this.hurtPos != null && TripodfishEntity.this.fleeFor > 0;
        }

        public void m_8056_() {
            TripodfishEntity.this.setStanding(false);
            this.fleeTarget = null;
        }

        public void m_8037_() {
            if ((this.fleeTarget == null || TripodfishEntity.this.m_20238_(this.fleeTarget) < 6.0) && TripodfishEntity.this.hurtPos != null) {
                this.fleeTarget = DefaultRandomPos.m_148407_((PathfinderMob)TripodfishEntity.this, (int)16, (int)7, (Vec3)Vec3.m_82512_((Vec3i)TripodfishEntity.this.hurtPos));
            }
            if (this.fleeTarget != null) {
                TripodfishEntity.this.m_21573_().m_26519_(this.fleeTarget.f_82479_, this.fleeTarget.f_82480_, this.fleeTarget.f_82481_, (double)1.6f);
            }
        }
    }

    private class WanderGoal
    extends Goal {
        private double x;
        private double y;
        private double z;
        private boolean wantsToStand;

        public WanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (TripodfishEntity.this.m_217043_().m_188503_(100) != 0 && TripodfishEntity.this.isStanding() && TripodfishEntity.this.timeStanding < TripodfishEntity.this.navigateTypeLength) {
                return false;
            }
            this.wantsToStand = TripodfishEntity.this.isStanding() ? false : TripodfishEntity.this.timeSwimming > 300 || TripodfishEntity.this.m_217043_().m_188501_() < 0.2f;
            Vec3 target = this.getPosition();
            if (target == null) {
                return false;
            }
            this.x = target.f_82479_;
            this.y = target.f_82480_;
            this.z = target.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            double dist = TripodfishEntity.this.m_20275_(this.x, this.y, this.z);
            return !TripodfishEntity.this.m_21573_().m_26571_() && dist > 9.0;
        }

        public void m_8056_() {
            TripodfishEntity.this.setStanding(false);
            TripodfishEntity.this.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
        }

        public void m_8041_() {
            int down;
            BlockPos ground = TripodfishEntity.this.m_20183_();
            for (down = 0; TripodfishEntity.this.m_9236_().m_6425_(ground).m_205070_(FluidTags.f_13131_) && down < 3 && ground.m_123342_() > TripodfishEntity.this.m_9236_().m_141937_(); ++down) {
                ground = ground.m_7495_();
            }
            if (this.wantsToStand && down <= 2) {
                TripodfishEntity.this.setStanding(true);
                TripodfishEntity.this.m_21573_().m_26573_();
                TripodfishEntity.this.m_20256_(Vec3.f_82478_);
            }
        }

        public BlockPos findWaterBlock() {
            BlockPos result = null;
            RandomSource random = TripodfishEntity.this.m_217043_();
            int range = 20;
            for (int i = 0; i < 15; ++i) {
                BlockPos blockPos = TripodfishEntity.this.m_20183_().m_7918_(random.m_188503_(range) - range / 2, random.m_188503_(range) - range / 2, random.m_188503_(range) - range / 2);
                if (!TripodfishEntity.this.m_9236_().m_6425_(blockPos).m_205070_(FluidTags.f_13131_) || blockPos.m_123342_() <= TripodfishEntity.this.m_9236_().m_141937_()) continue;
                result = blockPos;
            }
            return result;
        }

        public boolean isTargetBlocked(Vec3 target) {
            Vec3 Vector3d = new Vec3(TripodfishEntity.this.m_20185_(), TripodfishEntity.this.m_20188_(), TripodfishEntity.this.m_20189_());
            return TripodfishEntity.this.m_9236_().m_45547_(new ClipContext(Vector3d, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)TripodfishEntity.this)).m_6662_() != HitResult.Type.MISS;
        }

        @Nullable
        protected Vec3 getPosition() {
            BlockPos water = this.findWaterBlock();
            if (TripodfishEntity.this.m_20072_()) {
                if (water == null) {
                    return null;
                }
                while (TripodfishEntity.this.m_9236_().m_6425_(water.m_7495_()).m_205070_(FluidTags.f_13131_) && water.m_123342_() > TripodfishEntity.this.m_9236_().m_141937_() + 1) {
                    water = water.m_7495_();
                }
                BlockState seafloorState = TripodfishEntity.this.m_9236_().m_8055_(water.m_7495_());
                if (this.wantsToStand && (seafloorState.m_60713_(Blocks.f_50450_) || !seafloorState.m_60819_().m_76178_() && !seafloorState.m_60819_().m_205070_(FluidTags.f_13131_))) {
                    return null;
                }
                BlockPos above = water.m_6630_(this.wantsToStand ? 1 : 3 + TripodfishEntity.this.f_19796_.m_188503_(3));
                while (!TripodfishEntity.this.m_9236_().m_6425_(above).m_205070_(FluidTags.f_13131_) && above.m_123342_() > water.m_123342_()) {
                    above = above.m_7495_();
                }
                Vec3 vec3 = Vec3.m_82512_((Vec3i)above);
                if (!this.isTargetBlocked(vec3)) {
                    return vec3;
                }
                return null;
            }
            return water == null ? DefaultRandomPos.m_148403_((PathfinderMob)TripodfishEntity.this, (int)7, (int)3) : Vec3.m_82512_((Vec3i)water);
        }
    }
}

