/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACFoods;
import com.github.alexmodguy.alexscaves.server.item.CaveInfoItem;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BiomeTreatItem
extends CaveInfoItem {
    public BiomeTreatItem() {
        super(new Item.Properties().m_41487_(1), false);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41614_() && BiomeTreatItem.getCaveBiome(itemstack) == null) {
            if (player.m_36391_(itemstack.getFoodProperties((LivingEntity)player).m_38747_())) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)itemstack);
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public boolean m_41472_() {
        return true;
    }

    @Override
    public void m_7373_(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ResourceKey<Biome> biomeResourceKey = BiomeTreatItem.getCaveBiome(stack);
        if (biomeResourceKey == null) {
            tooltip.add((Component)Component.m_237115_((String)"item.alexscaves.biome_treat.desc").m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public static int getBiomeTreatColorOf(Level level, ItemStack stack) {
        float hue = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
        int rainbow = Color.HSBtoRGB(hue, 1.0f, 0.8f);
        if (stack.m_41720_() instanceof BiomeTreatItem) {
            ResourceKey<Biome> biomeResourceKey = BiomeTreatItem.getCaveBiome(stack);
            return biomeResourceKey == null ? rainbow : BiomeTreatItem.getBiomeColor(level, biomeResourceKey);
        }
        return -1;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        Player player;
        if (BiomeTreatItem.getCaveBiome(stack) == null && livingEntity instanceof Player && ((player = (Player)livingEntity).m_36324_().m_38702_() == 0 || player.m_7500_())) {
            return BiomeTreatItem.create(this, (ResourceKey<Biome>)((ResourceKey)level.m_204166_(livingEntity.m_20183_()).m_203543_().get()));
        }
        return super.m_5922_(stack, level, livingEntity);
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return BiomeTreatItem.getCaveBiome(stack) == null ? ACFoods.BIOME_TREAT : ACFoods.BIOME_TREAT_DONE;
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_11912_;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.DRINK;
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int useDir) {
        Vec3 vec3 = new Vec3(((double)level.m_213780_().m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
        vec3 = vec3.m_82496_(-living.m_146909_() * ((float)Math.PI / 180));
        vec3 = vec3.m_82524_(-living.m_146908_() * ((float)Math.PI / 180));
        double d0 = (double)(-level.m_213780_().m_188501_()) * 0.6 - 0.3;
        Vec3 vec31 = new Vec3(((double)level.m_213780_().m_188501_() - 0.5) * 0.3, d0, 0.6);
        vec31 = vec31.m_82496_(-living.m_146909_() * ((float)Math.PI / 180));
        vec31 = vec31.m_82524_(-living.m_146908_() * ((float)Math.PI / 180));
        vec31 = vec31.m_82520_(living.m_20185_(), living.m_20188_(), living.m_20189_());
        if (level instanceof ServerLevel) {
            ((ServerLevel)level).m_8767_((ParticleOptions)new ItemParticleOption((ParticleType)ACParticleRegistry.JELLY_BEAN_EAT.get(), stack), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
        } else {
            level.m_7106_((ParticleOptions)new ItemParticleOption((ParticleType)ACParticleRegistry.JELLY_BEAN_EAT.get(), stack), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
    }
}

