/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.SulfurBudBlock;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SulfurStackFeature
extends Feature<NoneFeatureConfiguration> {
    public SulfurStackFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos offset;
        int i;
        BlockPos below;
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        if (!level.m_8055_((below = context.m_159777_()).m_7495_()).m_60713_((Block)ACBlockRegistry.RADROCK.get())) {
            return false;
        }
        int centerHeight = 3 + randomsource.m_188503_(3);
        SulfurStackFeature.generatePillar(level, below, randomsource, centerHeight);
        for (i = 0; i < 2 + randomsource.m_188503_(2); ++i) {
            offset = below.m_7918_(randomsource.m_188503_(4) - 2, -randomsource.m_188503_(2), randomsource.m_188503_(4) - 2);
            int dist = (int)Math.ceil(offset.m_123333_((Vec3i)below));
            SulfurStackFeature.generatePillar(level, offset, randomsource, centerHeight - dist + randomsource.m_188503_(2));
        }
        for (i = 0; i < 4 + randomsource.m_188503_(6); ++i) {
            offset = below.m_7918_(randomsource.m_188503_(6) - 3, 4, randomsource.m_188503_(6) - 3);
            while (level.m_46859_(offset) && offset.m_123342_() > level.m_141937_()) {
                offset = offset.m_7495_();
            }
            if (!level.m_8055_(offset).m_60783_((BlockGetter)level, offset, Direction.UP) || !level.m_46859_(offset.m_7494_())) continue;
            SulfurStackFeature.placeRandomCrystal(level, offset.m_7494_(), randomsource);
        }
        return true;
    }

    private static boolean canReplace(BlockState state) {
        return (state.m_60795_() || state.m_247087_()) && !state.m_204336_(ACTagRegistry.UNMOVEABLE);
    }

    private static void generatePillar(WorldGenLevel level, BlockPos pos, RandomSource randomSource, int height) {
        BlockPos begin = pos.m_5484_(Direction.DOWN, 3);
        BlockPos stopPillarAt = pos.m_5484_(Direction.UP, height);
        while (!begin.equals((Object)stopPillarAt)) {
            if (!SulfurStackFeature.canReplace(level.m_8055_(begin = begin.m_121945_(Direction.UP)))) continue;
            level.m_7731_(begin, ((Block)ACBlockRegistry.SULFUR.get()).m_49966_(), 3);
        }
        if (SulfurStackFeature.canReplace(level.m_8055_(stopPillarAt.m_7494_())) && !(level.m_8055_(stopPillarAt).m_60734_() instanceof SulfurBudBlock)) {
            SulfurStackFeature.placeRandomCrystal(level, stopPillarAt.m_7494_(), randomSource);
        }
    }

    private static void placeRandomCrystal(WorldGenLevel level, BlockPos placeAt, RandomSource randomSource) {
        BlockState crystal = ((Block)ACBlockRegistry.SULFUR_CLUSTER.get()).m_49966_();
        switch (randomSource.m_188503_(3)) {
            case 0: {
                crystal = ((Block)ACBlockRegistry.SULFUR_BUD_SMALL.get()).m_49966_();
                break;
            }
            case 1: {
                crystal = ((Block)ACBlockRegistry.SULFUR_BUD_MEDIUM.get()).m_49966_();
                break;
            }
            case 2: {
                crystal = ((Block)ACBlockRegistry.SULFUR_BUD_LARGE.get()).m_49966_();
            }
        }
        if (crystal.m_60734_() instanceof SulfurBudBlock) {
            if (level.m_6425_(placeAt).m_192917_((Fluid)Fluids.f_76193_)) {
                crystal = (BlockState)crystal.m_61124_((Property)SulfurBudBlock.LIQUID_LOGGED, (Comparable)Integer.valueOf(1));
            } else if (level.m_6425_(placeAt).getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
                crystal = (BlockState)crystal.m_61124_((Property)SulfurBudBlock.LIQUID_LOGGED, (Comparable)Integer.valueOf(2));
            }
        }
        level.m_7731_(placeAt, crystal, 3);
        BlockPos drip = placeAt.m_7494_();
        while (level.m_46859_(drip) && drip.m_123342_() < level.m_151558_()) {
            drip = drip.m_7494_();
        }
        if (level.m_6425_(drip).m_76178_()) {
            level.m_7731_(drip, ((Block)ACBlockRegistry.ACIDIC_RADROCK.get()).m_49966_(), 3);
        }
    }
}

