/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public abstract class AbstractCaveGenerationStructurePiece
extends StructurePiece {
    protected final BlockPos chunkCorner;
    protected final BlockPos holeCenter;
    protected final int height;
    protected final int radius;
    private static boolean replaceBiomesError;

    public AbstractCaveGenerationStructurePiece(StructurePieceType pieceType, BlockPos chunkCorner, BlockPos holeCenter, int height, int radius) {
        this(pieceType, chunkCorner, holeCenter, height, radius, chunkCorner.m_123342_() - 2, chunkCorner.m_123342_() + 16);
    }

    public AbstractCaveGenerationStructurePiece(StructurePieceType pieceType, BlockPos chunkCorner, BlockPos holeCenter, int height, int radius, int minY, int maxY) {
        super(pieceType, 0, AbstractCaveGenerationStructurePiece.createBoundingBox(chunkCorner, minY, maxY));
        this.chunkCorner = chunkCorner;
        this.holeCenter = holeCenter;
        this.height = height;
        this.radius = radius;
    }

    public AbstractCaveGenerationStructurePiece(StructurePieceType pieceType, CompoundTag tag) {
        super(pieceType, tag);
        this.chunkCorner = new BlockPos(tag.m_128451_("TPX"), tag.m_128451_("TPY"), tag.m_128451_("TPZ"));
        this.holeCenter = new BlockPos(tag.m_128451_("HCX"), tag.m_128451_("HCY"), tag.m_128451_("HCZ"));
        this.height = tag.m_128451_("Height");
        this.radius = tag.m_128451_("Radius");
    }

    private static BoundingBox createBoundingBox(BlockPos origin, int minY, int maxY) {
        ChunkPos chunkPos = new ChunkPos(origin);
        return new BoundingBox(chunkPos.m_45604_(), minY, chunkPos.m_45605_(), chunkPos.m_45608_(), maxY, chunkPos.m_45609_());
    }

    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        tag.m_128405_("TPX", this.chunkCorner.m_123341_());
        tag.m_128405_("TPY", this.chunkCorner.m_123342_());
        tag.m_128405_("TPZ", this.chunkCorner.m_123343_());
        tag.m_128405_("HCX", this.holeCenter.m_123341_());
        tag.m_128405_("HCY", this.holeCenter.m_123342_());
        tag.m_128405_("HCZ", this.holeCenter.m_123343_());
        tag.m_128405_("Height", this.height);
        tag.m_128405_("Radius", this.radius);
    }

    public void replaceBiomes(WorldGenLevel level, ResourceKey<Biome> with, int belowLevel) {
        if (replaceBiomesError) {
            return;
        }
        try {
            Holder.Reference biomeHolder = level.m_9598_().m_175515_(Registries.f_256952_).m_246971_(with);
            ChunkAccess chunkAccess = level.m_46865_(this.chunkCorner);
            int stopY = level.m_5736_() - belowLevel;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            pos.m_122178_(this.chunkCorner.m_123341_(), stopY, this.chunkCorner.m_123343_());
            if (chunkAccess != null && !biomeHolder.m_203565_(Biomes.f_48202_)) {
                while (pos.m_123342_() > level.m_141937_()) {
                    LevelChunkSection section;
                    PalettedContainer container;
                    pos.m_122184_(0, -8, 0);
                    int sectionIndex = chunkAccess.m_151564_(pos.m_123342_());
                    if (sectionIndex < 0 || sectionIndex >= chunkAccess.m_7103_().length || (container = (section = chunkAccess.m_183278_(sectionIndex)).m_187996_().m_238334_()) == null) continue;
                    for (int biomeX = 0; biomeX < 4; ++biomeX) {
                        for (int biomeY = 0; biomeY < 4; ++biomeY) {
                            for (int biomeZ = 0; biomeZ < 4; ++biomeZ) {
                                container.m_63127_(biomeX, biomeY, biomeZ, (Object)biomeHolder);
                            }
                        }
                    }
                    section.f_187995_ = container;
                }
            }
        }
        catch (Exception e) {
            replaceBiomesError = true;
            AlexsCaves.LOGGER.warn("Could not replace biomes for Alex's Caves. Error will show only once - likely a world-gen mod incompatibility");
            e.printStackTrace();
        }
    }

    public void checkedSetBlock(WorldGenLevel level, BlockPos position, BlockState state) {
        if (this.m_73547_().m_71051_((Vec3i)position)) {
            level.m_7731_(position, state, 128);
        }
    }

    public BlockState checkedGetBlock(WorldGenLevel level, BlockPos position) {
        if (this.m_73547_().m_71051_((Vec3i)position)) {
            return level.m_8055_(position);
        }
        return Blocks.f_50626_.m_49966_();
    }

    public BlockState checkedGetBlockIgnoreY(WorldGenLevel level, BlockPos position) {
        if (this.m_73547_().m_260866_(position.m_123341_(), this.m_73547_().m_162396_(), position.m_123343_())) {
            return level.m_8055_(position);
        }
        return Blocks.f_50626_.m_49966_();
    }

    public void m_214092_(StructurePiece piece, StructurePieceAccessor accessor, RandomSource random) {
    }
}

