/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.config.BiomeGenerationConfig;
import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.UndergroundTemplateStructurePiece;
import com.github.alexmodguy.alexscaves.server.level.structure.processor.UndergroundCabinProcessor;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class UndergroundCabinStructurePiece
extends UndergroundTemplateStructurePiece {
    private ResourceKey<Biome> pickedBiome = null;

    public UndergroundCabinStructurePiece(StructureTemplateManager manager, ResourceLocation resourceLocation, BlockPos pos, Rotation rotation) {
        super((StructurePieceType)ACStructurePieceRegistry.UNDERGROUND_CABIN.get(), 0, manager, resourceLocation, resourceLocation.toString(), UndergroundCabinStructurePiece.makeSettings(rotation), pos);
    }

    public UndergroundCabinStructurePiece(StructureTemplateManager manager, CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.UNDERGROUND_CABIN.get(), tag, manager, (ResourceLocation x) -> UndergroundCabinStructurePiece.makeSettings(Rotation.valueOf((String)tag.m_128461_("Rotation"))));
    }

    public UndergroundCabinStructurePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        this(context.f_226956_(), tag);
    }

    private static StructurePlaceSettings makeSettings(Rotation rotation) {
        return new StructurePlaceSettings().m_74379_(rotation).m_74392_(true).m_163782_(false);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tag) {
        super.m_183620_(context, tag);
        tag.m_128359_("Rotation", this.f_73657_.m_74404_().name());
    }

    @Override
    public void m_213694_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        this.pickedBiome = this.pickBiome(randomSource);
        this.f_73657_.m_74394_().m_74383_((StructureProcessor)new UndergroundCabinProcessor());
        super.m_213694_(worldGenLevel, structureManager, chunkGenerator, randomSource, boundingBox, chunkPos, pos);
    }

    private ResourceKey<Biome> pickBiome(RandomSource randomSource) {
        ArrayList<ResourceKey<Biome>> biomeList = new ArrayList<ResourceKey<Biome>>(ACBiomeRegistry.ALEXS_CAVES_BIOMES);
        biomeList.removeIf(BiomeGenerationConfig::isBiomeDisabledCompletely);
        return biomeList.isEmpty() ? null : (ResourceKey)Util.m_214621_(biomeList, (RandomSource)randomSource);
    }

    protected void m_213704_(String string, BlockPos pos, ServerLevelAccessor accessor, RandomSource random, BoundingBox box) {
        accessor.m_7731_(pos, Blocks.f_50627_.m_49966_(), 0);
        switch (string) {
            case "loot_chest": {
                ResourceLocation chestLoot = this.pickedBiome == null ? BuiltInLootTables.f_78742_ : new ResourceLocation("alexscaves:chests/underground_cabin_" + this.pickedBiome.m_135782_().m_135815_());
                RandomizableContainerBlockEntity.m_222766_((BlockGetter)accessor, (RandomSource)random, (BlockPos)pos.m_7495_(), (ResourceLocation)chestLoot);
            }
        }
    }
}

