/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.processor;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.BaleenBoneBlock;
import com.github.alexmodguy.alexscaves.server.block.ThinBoneBlock;
import com.github.alexmodguy.alexscaves.server.level.structure.processor.ACStructureProcessorRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class WhalefallProcessor
extends StructureProcessor {
    public static final Codec<WhalefallProcessor> CODEC = Codec.unit(() -> INSTANCE_GRAVITY);
    public static final Codec<WhalefallProcessor> CODEC_SKULL = Codec.unit(() -> INSTANCE_NO_GRAVITY);
    public static final WhalefallProcessor INSTANCE_GRAVITY = new WhalefallProcessor(true);
    public static final WhalefallProcessor INSTANCE_NO_GRAVITY = new WhalefallProcessor(false);
    private final boolean gravity;

    public WhalefallProcessor(boolean gravity) {
        this.gravity = gravity;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos blockPosUnused, BlockPos pos, StructureTemplate.StructureBlockInfo relativeInfo, StructureTemplate.StructureBlockInfo info, StructurePlaceSettings settings) {
        BlockState in;
        RandomSource randomsource = settings.m_230326_(info.f_74675_());
        BlockPos fallTo = info.f_74675_();
        if (this.gravity) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(info.f_74675_().m_123341_(), info.f_74675_().m_123342_(), info.f_74675_().m_123343_());
            while (this.gravity && this.sinkThrough(levelReader.m_8055_((BlockPos)mutableBlockPos)) && mutableBlockPos.m_123342_() > levelReader.m_141937_()) {
                mutableBlockPos.m_122184_(0, -1, 0);
            }
            int i = mutableBlockPos.m_123342_();
            int j = relativeInfo.f_74675_().m_123342_() + 1;
            fallTo = new BlockPos(info.f_74675_().m_123341_(), i + j, info.f_74675_().m_123343_());
        }
        if ((in = info.f_74676_()).m_60713_((Block)ACBlockRegistry.BALEEN_BONE.get()) && (double)randomsource.m_188501_() < 0.2) {
            Direction.Axis axis = (Boolean)in.m_61143_((Property)BaleenBoneBlock.X) != false ? Direction.Axis.X : Direction.Axis.Z;
            in = (BlockState)((BlockState)((Block)ACBlockRegistry.THIN_BONE.get()).m_49966_().m_61124_((Property)ThinBoneBlock.f_55923_, (Comparable)axis)).m_61124_((Property)ThinBoneBlock.OFFSET, (Comparable)Integer.valueOf(0));
        }
        return new StructureTemplate.StructureBlockInfo(fallTo, in, info.f_74677_());
    }

    private boolean sinkThrough(BlockState blockState) {
        return !blockState.m_60819_().m_76178_() || blockState.m_204336_(ACTagRegistry.WHALEFALL_IGNORES) || blockState.m_60795_();
    }

    protected StructureProcessorType<?> m_6953_() {
        return this.gravity ? (StructureProcessorType)ACStructureProcessorRegistry.WHALEFALL.get() : (StructureProcessorType)ACStructureProcessorRegistry.WHALEFALL_SKULL.get();
    }
}

