/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.message;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.item.UpdatesStackTags;
import com.github.alexthe666.citadel.server.message.PacketBufferUtils;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class UpdateItemTagMessage {
    private int entityId;
    private ItemStack itemStackFrom;

    public UpdateItemTagMessage(int entityId, ItemStack itemStackFrom) {
        this.entityId = entityId;
        this.itemStackFrom = itemStackFrom;
    }

    public static UpdateItemTagMessage read(FriendlyByteBuf buf) {
        return new UpdateItemTagMessage(buf.readInt(), PacketBufferUtils.readItemStack((ByteBuf)buf));
    }

    public static void write(UpdateItemTagMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        PacketBufferUtils.writeItemStack((ByteBuf)buf, (ItemStack)message.itemStackFrom);
    }

    public static void handle(UpdateItemTagMessage message, Supplier<NetworkEvent.Context> context) {
        Entity holder;
        context.get().setPacketHandled(true);
        ServerPlayer playerSided = context.get().getSender();
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            playerSided = AlexsCaves.PROXY.getClientSidePlayer();
        }
        if (playerSided != null && (holder = playerSided.m_9236_().m_6815_(message.entityId)) instanceof LivingEntity) {
            Item item;
            LivingEntity living = (LivingEntity)holder;
            ItemStack stackFrom = message.itemStackFrom;
            ItemStack to = null;
            if (living.m_21120_(InteractionHand.MAIN_HAND).m_150930_(stackFrom.m_41720_())) {
                to = living.m_21120_(InteractionHand.MAIN_HAND);
            } else if (living.m_21120_(InteractionHand.OFF_HAND).m_150930_(stackFrom.m_41720_())) {
                to = living.m_21120_(InteractionHand.OFF_HAND);
            }
            if (to != null && (item = to.m_41720_()) instanceof UpdatesStackTags) {
                UpdatesStackTags updatesStackTags = (UpdatesStackTags)item;
                if (stackFrom.m_41783_() != null) {
                    updatesStackTags.updateTagFromServer(holder, to, stackFrom.m_41783_());
                }
            }
        }
    }
}

