/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.potion;

import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.potion.BubbledEffect;
import com.github.alexmodguy.alexscaves.server.potion.DarknessIncarnateEffect;
import com.github.alexmodguy.alexscaves.server.potion.DeepsightEffect;
import com.github.alexmodguy.alexscaves.server.potion.IrradiatedEffect;
import com.github.alexmodguy.alexscaves.server.potion.MagnetizedEffect;
import com.github.alexmodguy.alexscaves.server.potion.ProperBrewingRecipe;
import com.github.alexmodguy.alexscaves.server.potion.RageEffect;
import com.github.alexmodguy.alexscaves.server.potion.StunnedEffect;
import com.github.alexmodguy.alexscaves.server.potion.SugarRushEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ACEffectRegistry {
    public static final DeferredRegister<MobEffect> DEF_REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"alexscaves");
    public static final DeferredRegister<Potion> POTION_DEF_REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"alexscaves");
    public static final RegistryObject<MobEffect> MAGNETIZING = DEF_REG.register("magnetizing", () -> new MagnetizedEffect());
    public static final RegistryObject<MobEffect> STUNNED = DEF_REG.register("stunned", () -> new StunnedEffect());
    public static final RegistryObject<MobEffect> RAGE = DEF_REG.register("rage", () -> new RageEffect());
    public static final RegistryObject<MobEffect> IRRADIATED = DEF_REG.register("irradiated", () -> new IrradiatedEffect());
    public static final RegistryObject<MobEffect> BUBBLED = DEF_REG.register("bubbled", () -> new BubbledEffect());
    public static final RegistryObject<MobEffect> DEEPSIGHT = DEF_REG.register("deepsight", () -> new DeepsightEffect());
    public static final RegistryObject<MobEffect> DARKNESS_INCARNATE = DEF_REG.register("darkness_incarnate", () -> new DarknessIncarnateEffect());
    public static final RegistryObject<MobEffect> SUGAR_RUSH = DEF_REG.register("sugar_rush", () -> new SugarRushEffect());
    public static final RegistryObject<Potion> MAGNETIZING_POTION = POTION_DEF_REG.register("magnetizing", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)MAGNETIZING.get(), 3600)}));
    public static final RegistryObject<Potion> LONG_MAGNETIZING_POTION = POTION_DEF_REG.register("long_magnetizing", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)MAGNETIZING.get(), 9600)}));
    public static final RegistryObject<Potion> DEEPSIGHT_POTION = POTION_DEF_REG.register("deepsight", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)DEEPSIGHT.get(), 3600)}));
    public static final RegistryObject<Potion> LONG_DEEPSIGHT_POTION = POTION_DEF_REG.register("long_deepsight", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)DEEPSIGHT.get(), 9600)}));
    public static final RegistryObject<Potion> GLOWING_POTION = POTION_DEF_REG.register("glowing", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19619_, 3600)}));
    public static final RegistryObject<Potion> LONG_GLOWING_POTION = POTION_DEF_REG.register("long_glowing", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19619_, 9600)}));
    public static final RegistryObject<Potion> HASTE_POTION = POTION_DEF_REG.register("haste", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 3600)}));
    public static final RegistryObject<Potion> LONG_HASTE_POTION = POTION_DEF_REG.register("long_haste", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 9600)}));
    public static final RegistryObject<Potion> STRONG_HASTE_POTION = POTION_DEF_REG.register("strong_haste", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19598_, 1800, 1)}));
    public static final RegistryObject<Potion> STRONG_HUNGER_POTION = POTION_DEF_REG.register("strong_hunger", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(MobEffects.f_19612_, 1800, 4)}));
    public static final RegistryObject<Potion> SUGAR_RUSH_POTION = POTION_DEF_REG.register("sugar_rush", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)SUGAR_RUSH.get(), 1800)}));
    public static final RegistryObject<Potion> LONG_SUGAR_RUSH_POTION = POTION_DEF_REG.register("long_sugar_rush", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance((MobEffect)SUGAR_RUSH.get(), 3600)}));

    public static void setup() {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACItemRegistry.FERROUSLIME_BALL.get()}), ACEffectRegistry.createPotion(MAGNETIZING_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(MAGNETIZING_POTION)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), ACEffectRegistry.createPotion(LONG_MAGNETIZING_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACItemRegistry.LANTERNFISH.get()}), ACEffectRegistry.createPotion(DEEPSIGHT_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(DEEPSIGHT_POTION)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), ACEffectRegistry.createPotion(LONG_DEEPSIGHT_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACItemRegistry.BIOLUMINESSCENCE.get()}), ACEffectRegistry.createPotion(GLOWING_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(GLOWING_POTION)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), ACEffectRegistry.createPotion(LONG_GLOWING_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(Potions.f_43602_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACItemRegistry.CORRODENT_TEETH.get()}), ACEffectRegistry.createPotion(HASTE_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(HASTE_POTION)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), ACEffectRegistry.createPotion(LONG_HASTE_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(HASTE_POTION)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_}), ACEffectRegistry.createPotion(STRONG_HASTE_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(Potions.f_43614_)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ACItemRegistry.SWEET_TOOTH.get()}), ACEffectRegistry.createPotion(SUGAR_RUSH_POTION)));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ProperBrewingRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{ACEffectRegistry.createPotion(SUGAR_RUSH_POTION)}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42451_}), ACEffectRegistry.createPotion(LONG_SUGAR_RUSH_POTION)));
    }

    public static ItemStack createPotion(RegistryObject<Potion> potion) {
        return ACEffectRegistry.createPotion((Potion)potion.get());
    }

    public static ItemStack createPotion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
    }

    public static ItemStack createSplashPotion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)potion);
    }

    public static ItemStack createLingeringPotion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)potion);
    }

    public static ItemStack createJellybean(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)ACItemRegistry.JELLY_BEAN.get()), (Potion)potion);
    }
}

