/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.potion;

import com.github.alexmodguy.alexscaves.server.entity.util.DarknessIncarnateUserAccessor;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;

public class DarknessIncarnateEffect
extends MobEffect {
    private int lastDuration = -1;
    private int firstDuration = -1;

    protected DarknessIncarnateEffect() {
        super(MobEffectCategory.BENEFICIAL, 5312014);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        super.m_6742_(entity, amplifier);
        this.toggleFlight(entity, true);
        if (entity.m_20096_()) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.1, 0.0));
        }
        if ((entity.f_19797_ + entity.m_19879_() * 5) % 50 == 0 && entity.m_217043_().m_188503_(2) == 0) {
            entity.m_216990_((SoundEvent)ACSoundRegistry.DARKNESS_INCARNATE_IDLE.get());
        }
    }

    public List<ItemStack> getCurativeItems() {
        return List.of();
    }

    public void m_6386_(LivingEntity living, AttributeMap attributeMap, int i) {
        this.lastDuration = -1;
        this.firstDuration = -1;
        super.m_6386_(living, attributeMap, i);
        this.toggleFlight(living, false);
    }

    public int getActiveTime() {
        return this.firstDuration - this.lastDuration;
    }

    public void m_6385_(LivingEntity entity, AttributeMap map, int i) {
        this.lastDuration = -1;
        this.firstDuration = -1;
        super.m_6385_(entity, map, i);
    }

    public boolean m_6584_(int duration, int amplifier) {
        this.lastDuration = duration;
        if (duration <= 0) {
            this.lastDuration = -1;
            this.firstDuration = -1;
        }
        if (this.firstDuration == -1) {
            this.firstDuration = duration;
        }
        return duration > 0;
    }

    public void toggleFlight(LivingEntity living, boolean flight) {
        if (!living.m_9236_().f_46443_ && living instanceof ServerPlayer) {
            boolean trueFlight;
            ServerPlayer player = (ServerPlayer)living;
            boolean prevFlying = player.m_150110_().f_35935_;
            player.m_150110_().f_35936_ = trueFlight = this.isCreativePlayer(living) || flight;
            player.m_150110_().f_35935_ = trueFlight;
            float defaultFlightSpeed = 0.05f;
            if (flight) {
                player.m_150110_().m_35943_(defaultFlightSpeed * 4.0f);
            } else {
                player.m_150110_().m_35943_(defaultFlightSpeed);
                if (!player.m_5833_()) {
                    player.m_150110_().f_35935_ = false;
                    if (!player.m_7500_()) {
                        player.m_150110_().f_35936_ = false;
                    }
                    if (player instanceof DarknessIncarnateUserAccessor) {
                        DarknessIncarnateUserAccessor darknessIncarnateUserAccessor = (DarknessIncarnateUserAccessor)player;
                        darknessIncarnateUserAccessor.setSlowFallingFlag(true);
                    }
                }
            }
            if (prevFlying != flight) {
                player.m_6885_();
            }
        }
        living.f_19789_ = 0.0f;
    }

    public static float getIntensity(LivingEntity player, float partialTicks, float scaleBy) {
        MobEffectInstance instance = player.m_21124_((MobEffect)ACEffectRegistry.DARKNESS_INCARNATE.get());
        if (instance == null) {
            return 0.0f;
        }
        if (instance.m_267577_()) {
            return scaleBy;
        }
        DarknessIncarnateEffect effect = (DarknessIncarnateEffect)instance.m_19544_();
        float j = (float)effect.getActiveTime() + partialTicks;
        int duration = instance.m_19557_();
        return Math.min(scaleBy, Math.min(j, (float)duration + partialTicks)) / scaleBy;
    }

    public static boolean isInLight(LivingEntity living, int threshold) {
        BlockPos samplePos = living.m_20201_().m_20183_();
        int lightLevel = living.m_9236_().m_45517_(LightLayer.BLOCK, samplePos);
        float timeOfDay = living.m_9236_().m_46942_(1.0f);
        if (living.m_9236_().m_45527_(samplePos) && ((double)timeOfDay < 0.259 || (double)timeOfDay > 0.74)) {
            lightLevel = 15;
        }
        return lightLevel >= threshold;
    }

    private boolean isCreativePlayer(LivingEntity living) {
        Player player;
        return living instanceof Player && ((player = (Player)living).m_7500_() || player.m_5833_());
    }
}

