/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class HunterConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair2.getRight();
        CLIENT = (Client)specPair2.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> foodWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> foodInInventoryWhitelist;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> attackableWhitelist;

        public Common(ForgeConfigSpec.Builder builder) {
            Predicate<Object> validator = o -> o instanceof String;
            this.foodWhitelist = builder.translation("hunters_return.config.foodWhitelist").comment("Add Item for What Hunter Illager can eatable [example: minecraft:apple]").defineList("Hunter's Food Whitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:apple", "minecraft:cooked_beef", "minecraft:cooked_chicken", "minecraft:cooked_mutton", "minecraft:cooked_porkchop", "minecraft:beef", "minecraft:chicken", "minecraft:mutton", "minecraft:porkchop"}), validator);
            this.foodInInventoryWhitelist = builder.comment("Add Item for What Hunter Illager has in own Inventory [example: minecraft:apple]").defineList("Hunter's Food In Inventory Whitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:apple", "minecraft:cooked_beef", "minecraft:cooked_chicken", "minecraft:cooked_mutton", "minecraft:cooked_porkchop", "minecraft:beef", "minecraft:chicken", "minecraft:mutton", "minecraft:porkchop"}), validator);
            this.attackableWhitelist = builder.translation("hunters_return.config.attackableWhitelist").comment("Add Entity for What Hunter Illager can hunt [example: minecraft:chicken]").defineList("Hunter's Hunt Entity Whitelist", (List)Lists.newArrayList((Object[])new String[]{"minecraft:chicken", "minecraft:rabbit", "minecraft:pig", "minecraft:cow", "minecraft:sheep", "earthmobsmod:wooly_cow", "earthmobsmod:horned_sheep"}), validator);
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue oldAnimation;
        public final ForgeConfigSpec.BooleanValue oldModel;

        public Client(ForgeConfigSpec.Builder builder) {
            this.oldAnimation = builder.comment("Enable The Old animations").define("Enable Old Animations", false);
            this.oldModel = builder.comment("Enable The Old Model").define("Enable Old Model", false);
        }
    }
}

