/*
 * Decompiled with CFR 0.152.
 */
package baguchan.hunters_return.client.model;

import bagu_chan.bagus_lib.client.layer.IArmor;
import baguchan.hunters_return.HunterConfig;
import baguchan.hunters_return.client.animation.HunterAnimations;
import baguchan.hunters_return.entity.Hunter;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class HunterModel<T extends Hunter>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel,
IArmor {
    private final ModelPart body;
    private final ModelPart everything;
    private final ModelPart LeftLeg;
    private final ModelPart RightLeg;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart cape;
    public HumanoidModel.ArmPose leftArmPose = HumanoidModel.ArmPose.EMPTY;
    public HumanoidModel.ArmPose rightArmPose = HumanoidModel.ArmPose.EMPTY;

    public HunterModel(ModelPart root) {
        this.root = root;
        this.everything = root.m_171324_("everything");
        this.body = this.everything.m_171324_("body");
        this.cape = this.body.m_171324_("cape");
        this.LeftLeg = this.everything.m_171324_("left_leg");
        this.RightLeg = this.everything.m_171324_("right_leg");
        this.RightArm = this.body.m_171324_("right_arm");
        this.LeftArm = this.body.m_171324_("left_arm");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition everything = partdefinition.m_171599_("everything", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_leg = everything.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(49, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition right_leg = everything.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(44, 44).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = everything.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(28, 13).m_171488_(-4.0f, -11.75f, -2.5f, 8.0f, 14.0f, 5.0f, new CubeDeformation(0.75f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition cape = body.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(28, 32).m_171488_(-4.5f, 0.0f, 0.0f, 9.0f, 15.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-12.0f, (float)3.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(65, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.15f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.m_171599_("leftEye", CubeListBuilder.m_171558_().m_171514_(6, 7).m_171488_(0.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition rightEye = head.m_171599_("rightEye", CubeListBuilder.m_171558_().m_171514_(6, 7).m_171488_(-1.0f, -1.4604f, 0.74f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-2.5f, (float)-4.75f));
        PartDefinition righteyebrows = head.m_171599_("righteyebrows", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition righteyebrows_r1 = righteyebrows.m_171599_("righteyebrows_r1", CubeListBuilder.m_171558_().m_171514_(39, 0).m_171488_(-1.5f, -1.0f, -0.5902f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition lefteyebrows = head.m_171599_("lefteyebrows", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)2.5f, (float)-4.9604f, (float)-3.5196f));
        PartDefinition lefteyebrows_r1 = lefteyebrows.m_171599_("lefteyebrows_r1", CubeListBuilder.m_171558_().m_171514_(39, 0).m_171480_().m_171488_(-3.5f, -1.0f, -0.5902f, 5.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)-0.0902f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(16, 44).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_arm_r1 = left_arm.m_171599_("left_arm_r1", CubeListBuilder.m_171558_().m_171514_(17, 18).m_171488_(5.0f, 2.25f, -2.5f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(48, 32).m_171480_().m_171488_(0.0f, -0.75f, -2.5f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-1.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition leftHand = left_arm.m_171599_("leftHand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)9.5f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171480_().m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_arm_r1 = right_arm.m_171599_("right_arm_r1", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-7.0f, 2.25f, -3.0f, 2.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).m_171514_(24, 0).m_171480_().m_171488_(-5.0f, -0.75f, -3.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)1.0f, (float)-2.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition rightHand = right_arm.m_171599_("rightHand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)11.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AbstractIllager.IllagerArmPose abstractillager$illagerarmpose = ((Hunter)((Object)entityIn)).m_6768_();
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (this.f_102609_) {
            this.RightArm.f_104203_ = -0.62831855f;
            this.RightArm.f_104204_ = 0.0f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104203_ = -0.62831855f;
            this.LeftArm.f_104204_ = 0.0f;
            this.LeftArm.f_104205_ = 0.0f;
            this.RightLeg.f_104203_ = -1.4137167f;
            this.RightLeg.f_104204_ = 0.31415927f;
            this.RightLeg.f_104205_ = 0.07853982f;
            this.LeftLeg.f_104203_ = -1.4137167f;
            this.LeftLeg.f_104204_ = -0.31415927f;
            this.LeftLeg.f_104205_ = -0.07853982f;
        } else if (!((Boolean)HunterConfig.CLIENT.oldAnimation.get()).booleanValue()) {
            if (((Hunter)((Object)entityIn)).chargeAnimationState.m_216984_()) {
                if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                    this.m_267799_(HunterAnimations.HUNTER_RIGHT_WALK_ATTACK, limbSwing, limbSwingAmount, 1.0f, 1.5f);
                } else {
                    this.m_267799_(HunterAnimations.HUNTER_LEFT_WALK_ATTACK, limbSwing, limbSwingAmount, 1.0f, 1.5f);
                }
            } else if (!entityIn.m_5803_()) {
                this.m_267799_(HunterAnimations.HUNTER_WALK, limbSwing, limbSwingAmount, 1.0f, 1.5f);
            }
        } else {
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.RightArm.f_104204_ = 0.0f;
            this.RightArm.f_104205_ = 0.0f;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.LeftArm.f_104204_ = 0.0f;
            this.LeftArm.f_104205_ = 0.0f;
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.RightLeg.f_104204_ = 0.0f;
            this.RightLeg.f_104205_ = 0.0f;
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.LeftLeg.f_104204_ = 0.0f;
            this.LeftLeg.f_104205_ = 0.0f;
        }
        if (!((Boolean)HunterConfig.CLIENT.oldAnimation.get()).booleanValue()) {
            if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
                AnimationUtils.m_102097_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, (ModelPart)this.head, (boolean)true);
            } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
                HunterModel.animateCrossbowCharge(this.RightArm, this.LeftArm, entityIn, true);
            } else if (entityIn.m_5737_() == HumanoidArm.RIGHT) {
                this.m_233381_(((Hunter)((Object)entityIn)).shootAnimationState, HunterAnimations.HUNTER_RIGHT_SHOT, ageInTicks);
                this.m_233381_(((Hunter)((Object)entityIn)).chargeAnimationState, HunterAnimations.HUNTER_RIGHT_ATTACK_RANGE_CHARGE, ageInTicks);
                this.m_233385_(((Hunter)((Object)entityIn)).attackAnimationState, HunterAnimations.HUNTER_RIGHT_ATTACK_MELEE, ageInTicks, 1.5f);
                this.m_233381_(((Hunter)((Object)entityIn)).thrownAnimationState, HunterAnimations.HUNTER_LEFT_ATTACK_MELEE, ageInTicks);
            } else {
                this.m_233381_(((Hunter)((Object)entityIn)).shootAnimationState, HunterAnimations.HUNTER_LEFT_SHOT, ageInTicks);
                this.m_233381_(((Hunter)((Object)entityIn)).chargeAnimationState, HunterAnimations.HUNTER_LEFT_ATTACK_RANGE_CHARGE, ageInTicks);
                this.m_233385_(((Hunter)((Object)entityIn)).attackAnimationState, HunterAnimations.HUNTER_LEFT_ATTACK_MELEE, ageInTicks, 1.5f);
                this.m_233381_(((Hunter)((Object)entityIn)).thrownAnimationState, HunterAnimations.HUNTER_RIGHT_ATTACK_MELEE, ageInTicks);
            }
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.ATTACKING) {
            if (entityIn.m_21205_().m_41619_()) {
                AnimationUtils.m_102102_((ModelPart)this.LeftArm, (ModelPart)this.RightArm, (boolean)true, (float)this.f_102608_, (float)ageInTicks);
            } else {
                AnimationUtils.m_102091_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, entityIn, (float)this.f_102608_, (float)ageInTicks);
            }
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.SPELLCASTING) {
            this.RightArm.f_104202_ = 0.0f;
            this.RightArm.f_104200_ = -5.0f;
            this.LeftArm.f_104202_ = 0.0f;
            this.LeftArm.f_104200_ = 5.0f;
            this.RightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.RightArm.f_104205_ = 2.3561945f;
            this.LeftArm.f_104205_ = -2.3561945f;
            this.RightArm.f_104204_ = 0.0f;
            this.LeftArm.f_104204_ = 0.0f;
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.BOW_AND_ARROW) {
            this.RightArm.f_104204_ = -0.1f + this.head.f_104204_;
            this.RightArm.f_104203_ = -1.5707964f + this.head.f_104203_;
            this.LeftArm.f_104203_ = -0.9424779f + this.head.f_104203_;
            this.LeftArm.f_104204_ = this.head.f_104204_ - 0.4f;
            this.LeftArm.f_104205_ = 1.5707964f;
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_HOLD) {
            AnimationUtils.m_102097_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, (ModelPart)this.head, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE) {
            AnimationUtils.m_102086_((ModelPart)this.RightArm, (ModelPart)this.LeftArm, entityIn, (boolean)true);
        } else if (abstractillager$illagerarmpose == AbstractIllager.IllagerArmPose.CELEBRATING) {
            this.RightArm.f_104202_ = 0.0f;
            this.RightArm.f_104200_ = -5.0f;
            this.RightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.RightArm.f_104205_ = 2.670354f;
            this.RightArm.f_104204_ = 0.0f;
            this.LeftArm.f_104202_ = 0.0f;
            this.LeftArm.f_104200_ = 5.0f;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.05f;
            this.LeftArm.f_104205_ = -2.3561945f;
            this.LeftArm.f_104204_ = 0.0f;
        }
    }

    public static void animateCrossbowCharge(ModelPart p_102087_, ModelPart p_102088_, LivingEntity p_102089_, boolean p_102090_) {
        ModelPart modelpart = p_102090_ ? p_102087_ : p_102088_;
        ModelPart modelpart1 = p_102090_ ? p_102088_ : p_102087_;
        modelpart.f_104204_ = p_102090_ ? -0.8f : 0.8f;
        modelpart1.f_104203_ = modelpart.f_104203_ = -0.97079635f;
        float f = p_102089_.m_21211_().m_41779_();
        float f1 = Mth.m_14036_((float)p_102089_.m_21252_(), (float)0.0f, (float)f);
        float f2 = f1 / f;
        modelpart1.f_104204_ = Mth.m_14179_((float)f2, (float)0.4f, (float)0.85f) * (float)(p_102090_ ? 1 : -1);
        modelpart1.f_104203_ = Mth.m_14179_((float)f2, (float)modelpart1.f_104203_, (float)-1.5707964f);
    }

    public void prepareMobModel(T entity, float p_103794_, float p_103795_, float p_103796_) {
        this.rightArmPose = HumanoidModel.ArmPose.EMPTY;
        this.leftArmPose = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemstack = entity.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_150930_(Items.f_220219_) && entity.m_6117_()) {
            if (entity.m_5737_() == HumanoidArm.RIGHT) {
                this.rightArmPose = HumanoidModel.ArmPose.TOOT_HORN;
            } else {
                this.leftArmPose = HumanoidModel.ArmPose.TOOT_HORN;
            }
        }
        super.m_6839_(entity, p_103794_, p_103795_, p_103796_);
    }

    private void poseRightArm(T p_102876_) {
        switch (this.rightArmPose) {
            case SPYGLASS: {
                this.RightArm.f_104203_ = Mth.m_14036_((float)(this.head.f_104203_ - 1.9198622f - (p_102876_.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.RightArm.f_104204_ = this.head.f_104204_ - 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.RightArm.f_104203_ = Mth.m_14036_((float)this.head.f_104203_, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.RightArm.f_104204_ = this.head.f_104204_ - 0.5235988f;
            }
        }
    }

    private void poseLeftArm(T p_102879_) {
        switch (this.leftArmPose) {
            case SPYGLASS: {
                this.LeftArm.f_104203_ = Mth.m_14036_((float)(this.head.f_104203_ - 1.9198622f - (p_102879_.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
                this.LeftArm.f_104204_ = this.head.f_104204_ + 0.2617994f;
                break;
            }
            case TOOT_HORN: {
                this.LeftArm.f_104203_ = Mth.m_14036_((float)this.head.f_104203_, (float)-1.2f, (float)1.2f) - 1.4835298f;
                this.LeftArm.f_104204_ = this.head.f_104204_ + 0.5235988f;
            }
        }
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm p_102925_, PoseStack p_102926_) {
        this.everything.m_104299_(p_102926_);
        this.body.m_104299_(p_102926_);
        this.getArm(p_102925_).m_104299_(p_102926_);
    }

    public void copyPropertiesTo(HunterModel<T> p_102873_) {
        super.m_102624_(p_102873_);
        p_102873_.leftArmPose = this.leftArmPose;
        p_102873_.rightArmPose = this.rightArmPose;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        this.everything.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -0.1f, 0.0f);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        this.everything.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_252880_(0.0f, -0.75f, 0.0f);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        this.everything.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        this.everything.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        modelPart.m_104299_(poseStack);
        poseStack.m_85841_(1.05f, 1.05f, 1.05f);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.RightArm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.LeftArm);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.RightLeg);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.LeftLeg);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }
}

