/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons;

import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.EntityAttributesCreateContext;
import fuzs.puzzleslib.api.core.v1.context.ModLifecycleContext;
import fuzs.puzzleslib.api.core.v1.context.SpawnPlacementsContext;
import fuzs.puzzleslib.api.event.v1.entity.ServerEntityLevelEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.tinyskeletons.handler.BabyConversionHandler;
import fuzs.tinyskeletons.init.ModRegistry;
import fuzs.tinyskeletons.world.entity.monster.BabyStray;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinySkeletons
implements ModConstructor {
    public static final String MOD_ID = "tinyskeletons";
    public static final String MOD_NAME = "Tiny Skeletons";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Tiny Skeletons");

    public void onConstructMod() {
        ModRegistry.touch();
        TinySkeletons.registerHandlers();
    }

    private static void registerHandlers() {
        PlayerInteractEvents.USE_ENTITY_AT.register(BabyConversionHandler::onEntityInteract);
        ServerEntityLevelEvents.LOAD.register(BabyConversionHandler::onEntityLoad);
    }

    public void onCommonSetup(ModLifecycleContext context) {
        BabyConversionHandler.registerConversion((EntityType<? extends Mob>)EntityType.f_20524_, (EntityType<? extends Mob>)((EntityType)ModRegistry.BABY_SKELETON_ENTITY_TYPE.get()));
        BabyConversionHandler.registerConversion((EntityType<? extends Mob>)EntityType.f_20497_, (EntityType<? extends Mob>)((EntityType)ModRegistry.BABY_WITHER_SKELETON_ENTITY_TYPE.get()));
        BabyConversionHandler.registerConversion((EntityType<? extends Mob>)EntityType.f_20481_, (EntityType<? extends Mob>)((EntityType)ModRegistry.BABY_STRAY_ENTITY_TYPE.get()));
    }

    public void onRegisterSpawnPlacements(SpawnPlacementsContext context) {
        context.registerSpawnPlacement((EntityType)ModRegistry.BABY_SKELETON_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.BABY_WITHER_SKELETON_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_);
        context.registerSpawnPlacement((EntityType)ModRegistry.BABY_STRAY_ENTITY_TYPE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BabyStray::checkBabyStraySpawnRules);
    }

    public void onEntityAttributeCreation(EntityAttributesCreateContext context) {
        context.registerEntityAttributes((EntityType)ModRegistry.BABY_SKELETON_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.3));
        context.registerEntityAttributes((EntityType)ModRegistry.BABY_WITHER_SKELETON_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.3));
        context.registerEntityAttributes((EntityType)ModRegistry.BABY_STRAY_ENTITY_TYPE.get(), Monster.m_33035_().m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.3));
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

