/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.client.packs;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.blaze3d.platform.NativeImage;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import fuzs.tinyskeletons.client.renderer.entity.BabySkeletonRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyStrayRenderer;
import fuzs.tinyskeletons.client.renderer.entity.BabyWitherSkeletonRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class BabySkeletonPackResources
extends AbstractModPackResources {
    private static final ResourceLocation SKELETON_LOCATION = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    private static final ResourceLocation STRAY_SKELETON_LOCATION = new ResourceLocation("textures/entity/skeleton/stray.png");
    private static final ResourceLocation WITHER_SKELETON_LOCATION = new ResourceLocation("textures/entity/skeleton/wither_skeleton.png");
    private static final BiMap<ResourceLocation, ResourceLocation> BABY_SKELETON_LOCATIONS = ImmutableBiMap.of((Object)BabySkeletonRenderer.BABY_SKELETON_LOCATION, (Object)SKELETON_LOCATION, (Object)BabyStrayRenderer.BABY_STRAY_SKELETON_LOCATION, (Object)STRAY_SKELETON_LOCATION, (Object)BabyWitherSkeletonRenderer.BABY_WITHER_SKELETON_LOCATION, (Object)WITHER_SKELETON_LOCATION);
    private static final int VANILLA_SKELETON_TEXTURE_WIDTH = 64;
    private static final int VANILLA_SKELETON_TEXTURE_HEIGHT = 32;
    private final ResourceManager resourceManager;
    private final VanillaPackResources vanillaPackResources;

    public BabySkeletonPackResources() {
        Minecraft minecraft = Minecraft.m_91087_();
        this.resourceManager = minecraft.m_91098_();
        this.vanillaPackResources = minecraft.m_246804_();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public IoSupplier<InputStream> m_214146_(PackType packType, ResourceLocation location) {
        ResourceLocation vanillaSkeletonLocation = (ResourceLocation)BABY_SKELETON_LOCATIONS.get((Object)location);
        if (vanillaSkeletonLocation == null) {
            return null;
        }
        Optional resource = this.resourceManager.m_213713_(vanillaSkeletonLocation);
        if (!resource.isPresent()) return null;
        try (NativeImage image = NativeImage.m_85058_((InputStream)((Resource)resource.get()).m_215507_());){
            if (image.m_84982_() / image.m_85084_() == 2) return () -> ((Resource)((Resource)resource.get())).m_215507_();
            IoSupplier ioSupplier = this.vanillaPackResources.m_214146_(packType, vanillaSkeletonLocation);
            return ioSupplier;
        }
        catch (IOException iOException) {
        }
        return () -> ((Resource)((Resource)resource.get())).m_215507_();
    }

    public Set<String> m_5698_(PackType type) {
        return BABY_SKELETON_LOCATIONS.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
    }
}

