/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tinyskeletons.world.entity.ai.goal;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class RangedBowEasyAttackGoal<T extends Monster>
extends RangedBowAttackGoal<T> {
    private final T entity;
    private final double moveSpeedAmplifier;
    private int attackCooldown;
    private final int maxAttackTime;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;

    public RangedBowEasyAttackGoal(T mob, double chaseTargetSpeed, int attackCooldown, int maxAttackTime, float maxAttackDistance) {
        super(mob, chaseTargetSpeed, attackCooldown, maxAttackDistance);
        this.entity = mob;
        this.moveSpeedAmplifier = chaseTargetSpeed;
        this.attackCooldown = attackCooldown;
        this.maxAttackTime = maxAttackTime;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
    }

    public void m_25797_(int attackCooldownIn) {
        this.attackCooldown = attackCooldownIn;
    }

    public void m_8041_() {
        this.entity.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.m_5810_();
    }

    public void m_8037_() {
        LivingEntity attackTarget = this.entity.m_5448_();
        if (attackTarget != null) {
            double distanceToTarget = this.entity.m_20275_(attackTarget.m_20185_(), attackTarget.m_20186_(), attackTarget.m_20189_());
            boolean canSeeTarget = this.entity.m_21574_().m_148306_((Entity)attackTarget);
            if (canSeeTarget != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            boolean moveTowardsTarget = false;
            if (distanceToTarget <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.m_21573_().m_26573_();
                moveTowardsTarget = distanceToTarget > (double)(this.maxAttackDistance * 0.75f);
            } else {
                this.entity.m_21573_().m_5624_((Entity)attackTarget, this.moveSpeedAmplifier);
            }
            if (moveTowardsTarget) {
                this.entity.m_21566_().m_24988_(0.5f, 0.0f);
                this.entity.m_21391_((Entity)attackTarget, 30.0f, 30.0f);
            } else {
                this.entity.m_21563_().m_24960_((Entity)attackTarget, 30.0f, 30.0f);
            }
            if (this.entity.m_6117_()) {
                int useCount;
                if (!canSeeTarget && this.seeTime < -this.maxAttackTime) {
                    this.entity.m_5810_();
                } else if (canSeeTarget && (useCount = this.entity.m_21252_()) >= 20) {
                    this.entity.m_5810_();
                    double distanceVelocity = Math.sqrt(distanceToTarget) / Math.sqrt(this.maxAttackDistance);
                    ((RangedAttackMob)this.entity).m_6504_(attackTarget, Mth.m_14036_((float)((float)distanceVelocity), (float)0.1f, (float)1.0f) * BowItem.m_40661_((int)useCount));
                    this.attackTime = Mth.m_14107_((double)(distanceVelocity * (double)((float)this.maxAttackTime - (float)this.attackCooldown / 2.0f) + (double)((float)this.attackCooldown / 2.0f)));
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -this.maxAttackTime) {
                this.entity.m_6672_(ProjectileUtil.m_37297_(this.entity, (Item)Items.f_42411_));
            }
        }
    }
}

