/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.itemshowplus;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class ItemShowPlus
extends JavaPlugin
implements CommandExecutor {
    private String prefix;
    private String noItemMessage;
    private String formatMessage;
    private boolean showEnchantments;
    private boolean showAttributes;
    private boolean showLore;
    private boolean showDurability;
    private int cooldownSeconds;
    private List<String> disabledWorlds;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getCommand("item").setExecutor(this);
        this.getCommand("i").setExecutor(this);
        this.getLogger().info("ItemShowPlus has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("ItemShowPlus has been disabled!");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.prefix = ChatColor.translateAlternateColorCodes('&', config.getString("messages.prefix"));
        this.noItemMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.no-item"));
        this.formatMessage = ChatColor.translateAlternateColorCodes('&', config.getString("messages.format"));
        this.showEnchantments = config.getBoolean("display.show-enchantments");
        this.showAttributes = config.getBoolean("display.show-attributes");
        this.showLore = config.getBoolean("display.show-lore");
        this.showDurability = config.getBoolean("display.show-durability");
        this.cooldownSeconds = config.getInt("cooldown-seconds");
        this.disabledWorlds = config.getStringList("disabled-worlds");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.prefix + String.valueOf((Object)ChatColor.RED) + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (this.disabledWorlds.contains(player.getWorld().getName())) {
            player.sendMessage(this.prefix + String.valueOf((Object)ChatColor.RED) + "You cannot use this command in this world!");
            return true;
        }
        if (!player.hasPermission("itemshowplus.show")) {
            player.sendMessage(this.prefix + String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command!");
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            player.sendMessage(this.prefix + this.noItemMessage);
            return true;
        }
        String itemName = this.getItemName(item);
        ArrayList<CallSite> hoverText = new ArrayList<CallSite>();
        if (this.showEnchantments && item.getEnchantments().size() > 0) {
            hoverText.add((CallSite)((Object)(String.valueOf((Object)ChatColor.GRAY) + "Enchantments:")));
            for (Map.Entry<Enchantment, Integer> entry : item.getEnchantments().entrySet()) {
                Object enchName = entry.getKey().getName().toLowerCase().replace("_", " ");
                enchName = ((String)enchName).substring(0, 1).toUpperCase() + ((String)enchName).substring(1);
                hoverText.add((CallSite)((Object)(String.valueOf((Object)ChatColor.BLUE) + "  " + (String)enchName + " " + this.toRoman(entry.getValue()))));
            }
        }
        if (this.showLore && item.hasItemMeta() && item.getItemMeta().hasLore()) {
            List<String> lore = item.getItemMeta().getLore();
            hoverText.add((CallSite)((Object)(String.valueOf((Object)ChatColor.GRAY) + "Lore:")));
            for (String line : lore) {
                hoverText.add((CallSite)((Object)("  " + line)));
            }
        }
        if (this.showDurability && item.getType().getMaxDurability() > 0) {
            short maxDurability = item.getType().getMaxDurability();
            int n = maxDurability - item.getDurability();
            hoverText.add((CallSite)((Object)(String.valueOf((Object)ChatColor.GRAY) + "Durability: " + String.valueOf((Object)ChatColor.GREEN) + n + "/" + maxDurability)));
        }
        String message = this.formatMessage.replace("{player}", player.getDisplayName()).replace("{item}", itemName);
        TextComponent textComponent = new TextComponent(message);
        StringBuilder hoverTextBuilder = new StringBuilder();
        for (String string : hoverText) {
            hoverTextBuilder.append(string).append("\n");
        }
        if (hoverTextBuilder.length() > 0) {
            hoverTextBuilder.setLength(hoverTextBuilder.length() - 1);
            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hoverTextBuilder.toString()).create());
            textComponent.setHoverEvent(hoverEvent);
        }
        for (Player player2 : this.getServer().getOnlinePlayers()) {
            player2.spigot().sendMessage((BaseComponent)textComponent);
        }
        return true;
    }

    private String getItemName(ItemStack item) {
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return item.getItemMeta().getDisplayName();
        }
        String name = item.getType().name().toLowerCase().replace("_", " ");
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private String toRoman(int number) {
        if (number <= 0 || number > 10) {
            return Integer.toString(number);
        }
        String[] roman = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X"};
        return roman[number - 1];
    }
}

