/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecraftalphaargmod.entity;

import net.mcreator.minecraftalphaargmod.init.TheArgContainerModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class RecruiterV2Entity
extends PathfinderMob {
    public int stareTimer = 0;
    public boolean getTheFrickOut = false;
    private boolean initializedSpawnPos = false;
    private int ticksSinceSpawn = 0;
    private static final int GRACE_TICKS = 20;
    private boolean controllerMode = false;
    private boolean spawnedThisCycle = false;

    public RecruiterV2Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RecruiterV2Entity>)((EntityType)TheArgContainerModEntities.RECRUITER_V_2.get()), world);
    }

    public RecruiterV2Entity(EntityType<RecruiterV2Entity> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)" "));
        this.m_20340_(true);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 100.0f));
    }

    public void m_8119_() {
        Player player;
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        ++this.ticksSinceSpawn;
        if (!this.initializedSpawnPos) {
            this.initializedSpawnPos = true;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                Player p = sl.m_45930_((Entity)this, 256.0);
                if (p != null) {
                    double angle = this.m_217043_().m_188500_() * (Math.PI * 2);
                    double radius = 24.0 + this.m_217043_().m_188500_() * 24.0;
                    double tx = p.m_20185_() + Math.cos(angle) * radius;
                    double tz = p.m_20189_() + Math.sin(angle) * radius;
                    int ty = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mth.m_14107_((double)tx), Mth.m_14107_((double)tz));
                    this.m_7678_(tx + 0.5, (double)ty + 1.0, tz + 0.5, 0.0f, 0.0f);
                } else {
                    BlockPos spawn = sl.m_220360_();
                    int y = sl.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawn.m_123341_(), spawn.m_123343_());
                    this.m_7678_((double)spawn.m_123341_() + 0.5, (double)y + 1.0, (double)spawn.m_123343_() + 0.5, 0.0f, 0.0f);
                }
            }
        }
        if (this.controllerMode) {
            if (!this.spawnedThisCycle) {
                this.gone();
                return;
            }
            this.spawnedThisCycle = false;
        }
        if ((player = this.m_9236_().m_45930_((Entity)this, 256.0)) == null) {
            return;
        }
        double yaw = Math.toDegrees(Math.atan2(this.m_20185_() - player.m_20185_(), -(this.m_20189_() - player.m_20189_())));
        float yawF = (float)yaw;
        this.m_146922_(yawF);
        this.m_5616_(yawF);
        this.m_5618_(yawF);
        float dist = this.m_20270_((Entity)player);
        if (this.ticksSinceSpawn > 20 && dist < 19.0f) {
            this.gone();
            return;
        }
        boolean hasLoS = this.m_142582_((Entity)player);
        float diff = Mth.m_14177_((float)(player.m_146908_() - this.m_146908_()));
        float closenessTo180 = Math.abs(Math.abs(diff) - 180.0f);
        if (closenessTo180 < 10.0f && hasLoS) {
            ++this.stareTimer;
            if (this.stareTimer > 70) {
                this.getTheFrickOut = true;
                this.gone();
            }
        } else if (this.stareTimer > 0) {
            this.stareTimer = Math.max(0, this.stareTimer - 1);
        }
    }

    public void enableControllerMode(boolean enabled) {
        this.controllerMode = enabled;
    }

    public void markSpawnedThisCycle() {
        this.spawnedThisCycle = true;
    }

    private void gone() {
        this.m_146870_();
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_7640_() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.m_7640_() instanceof Player) {
            return false;
        }
        if (damagesource.m_7640_() instanceof ThrownPotion || damagesource.m_7640_() instanceof AreaEffectCloud) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268565_) || damagesource.m_276093_(DamageTypes.f_268448_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268714_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268526_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268482_)) {
            return false;
        }
        if (damagesource.m_276093_(DamageTypes.f_268493_) || damagesource.m_276093_(DamageTypes.f_268641_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }
}

