/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecraftalphaargmod.gaze;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_arg_container", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class EndstoneWave {
    private static final int DEFAULT_VISITS_PER_TICK = 20000;
    private static final List<Task> TASKS = new ArrayList<Task>();
    public static final Set<String> BLOCK_BLACKLIST = new HashSet<String>(Arrays.asList("minecraft:bedrock", "minecraft:water", "minecraft:lava", "minecraft:end_portal", "minecraft:end_gateway", "minecraft:nether_portal", "the_arg_container:celestial_flame", "the_arg_container:water_lily"));

    private EndstoneWave() {
    }

    public static void start(ServerPlayer player, int radius, Runnable onComplete) {
        ServerLevel level = player.m_284548_();
        BlockPos center = player.m_20183_();
        TASKS.add(new Task(level, center, radius, 20000, onComplete));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || TASKS.isEmpty()) {
            return;
        }
        Iterator<Task> it = TASKS.iterator();
        while (it.hasNext()) {
            Task t = it.next();
            if (t.isInvalid()) {
                it.remove();
                continue;
            }
            t.tick();
            if (!t.isDone()) continue;
            it.remove();
        }
    }

    private static final class Task {
        private final ServerLevel level;
        private final int cx;
        private final int cy;
        private final int cz;
        private final int radius;
        private final long r2;
        private final int visitsPerTick;
        private final int minY;
        private final int maxY;
        private final BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        private final Runnable onComplete;
        private int dx;
        private int dy;
        private int dz;
        private boolean done;

        Task(ServerLevel level, BlockPos center, int radius, int visitsPerTick, Runnable onComplete) {
            this.level = level;
            this.cx = center.m_123341_();
            this.cy = center.m_123342_();
            this.cz = center.m_123343_();
            this.radius = radius;
            this.r2 = (long)radius * (long)radius;
            this.visitsPerTick = Math.max(1000, visitsPerTick);
            this.minY = level.m_141937_();
            this.maxY = level.m_151558_() - 1;
            this.dx = -radius;
            this.dy = -radius;
            this.dz = -radius;
            this.onComplete = onComplete;
        }

        void tick() {
            if (this.done) {
                return;
            }
            for (int visited = 0; visited < this.visitsPerTick && !this.done; ++visited) {
                long dist2;
                int x = this.cx + this.dx;
                int y = this.cy + this.dy;
                int z = this.cz + this.dz;
                if (y >= this.minY && y <= this.maxY && (dist2 = (long)this.dx * (long)this.dx + (long)this.dy * (long)this.dy + (long)this.dz * (long)this.dz) <= this.r2) {
                    this.mpos.m_122178_(x, y, z);
                    if (!this.level.m_46859_((BlockPos)this.mpos)) {
                        Block currentBlock = this.level.m_8055_((BlockPos)this.mpos).m_60734_();
                        FluidState fluid = this.level.m_6425_((BlockPos)this.mpos);
                        if (!BLOCK_BLACKLIST.contains(currentBlock) && fluid.m_76152_() == Fluids.f_76191_) {
                            this.level.m_46597_((BlockPos)this.mpos, Blocks.f_50259_.m_49966_());
                        }
                    }
                }
                this.advance();
            }
            if (this.done && this.onComplete != null) {
                this.level.m_7654_().execute(this.onComplete);
            }
        }

        private void advance() {
            ++this.dz;
            if (this.dz > this.radius) {
                this.dz = -this.radius;
                ++this.dy;
                if (this.dy > this.radius) {
                    this.dy = -this.radius;
                    ++this.dx;
                    if (this.dx > this.radius) {
                        this.done = true;
                    }
                }
            }
        }

        boolean isDone() {
            return this.done;
        }

        boolean isInvalid() {
            return this.level == null || !this.level.m_7654_().m_130010_();
        }
    }
}

