/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecraftalphaargmod.gaze;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.minecraftalphaargmod.gaze.EndstoneWave;
import net.mcreator.minecraftalphaargmod.util.MoonLookUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="the_arg_container", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class MoonGazeServerListener {
    public static final String MODID = "the_arg_container";
    private static final int REQUIRED_TICKS = 600;
    private static final double TOLERANCE_DEGREES = 10.0;
    private static final Component MESSAGE = Component.m_237113_((String)"You shouldn't have done that.");
    private static final Map<UUID, Integer> GAZE_TICKS = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = e.player;
        if (p.m_9236_().f_46443_) {
            return;
        }
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)p;
        boolean looking = MoonLookUtil.isLookingAtMoon((Player)sp, 0.0f, 10.0);
        int ticks = GAZE_TICKS.getOrDefault(sp.m_20148_(), 0);
        ticks = looking ? Math.min(600, ticks + 1) : 0;
        GAZE_TICKS.put(sp.m_20148_(), ticks);
        if (ticks >= 600) {
            EndstoneWave.start(sp, 70, () -> {
                sp.m_213846_(MESSAGE);
                sp.f_8906_.m_9942_(MESSAGE);
            });
            GAZE_TICKS.remove(sp.m_20148_());
        }
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        GAZE_TICKS.remove(e.getEntity().m_20148_());
    }
}

