/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecraftalphaargmod.mixins;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.mcreator.minecraftalphaargmod.configuration.McconfigConfiguration;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TitleScreen.class})
public class TitleScreenMixin
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(TitleScreenMixin.class);
    private static final int TOTAL_ROW_WIDTH = 200;
    private static final int ROW_SPACING = 4;
    private static final int BUTTON_HEIGHT = 20;
    private static final int QUICK_BUTTON_MIN_WIDTH = 60;
    private static final int QUICK_BUTTON_MAX_WIDTH = 90;
    private static final int QUICK_BUTTON_PADDING = 12;
    private static final String QUICK_BUTTON_TEXT = "Quickload";
    private Button quickloadButton;
    private int cachedQuickloadTextWidth = -1;
    private final AtomicBoolean isLoading = new AtomicBoolean(false);

    protected TitleScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"createNormalMenuOptions"}, at={@At(value="TAIL")})
    private void addQuickloadButton(int y, int spacingY, CallbackInfo ci) {
        if (!this.isInitializationValid()) {
            return;
        }
        Optional<LevelSummary> lastWorld = this.getLastPlayedWorld();
        if (lastWorld.isPresent()) {
            this.createQuickloadButton(y, lastWorld.get());
        }
        this.adjustSingleplayerButton(y, lastWorld.isPresent());
    }

    private boolean isInitializationValid() {
        return this.f_96541_ != null && this.f_96547_ != null && (Boolean)McconfigConfiguration.QUICKLOAD_BUTTON.get() != false;
    }

    private void createQuickloadButton(int y, LevelSummary lastWorld) {
        int quickloadWidth = this.calculateQuickloadButtonWidth();
        int[] buttonPositions = this.calculateButtonPositions(quickloadWidth);
        Tooltip tooltip = Tooltip.m_257550_((Component)Component.m_237113_((String)String.format("Load: \"%s\"", lastWorld.m_78361_())));
        this.quickloadButton = Button.m_253074_((Component)Component.m_237113_((String)QUICK_BUTTON_TEXT), button -> {
            if (!this.isLoading.get()) {
                this.isLoading.set(true);
                button.f_93623_ = false;
                this.loadLastWorld(lastWorld, button);
            }
        }).m_252987_(buttonPositions[1], y, quickloadWidth, 20).m_257505_(tooltip).m_253136_();
        this.m_142416_((GuiEventListener)this.quickloadButton);
    }

    private int calculateQuickloadButtonWidth() {
        if (this.cachedQuickloadTextWidth == -1) {
            this.cachedQuickloadTextWidth = this.f_96547_.m_92895_(QUICK_BUTTON_TEXT) + 12;
        }
        return Math.max(60, Math.min(90, this.cachedQuickloadTextWidth));
    }

    private int[] calculateButtonPositions(int quickloadWidth) {
        int centerX = this.f_96543_ / 2;
        int rowLeft = centerX - 100;
        int singleplayerWidth = 196 - quickloadWidth;
        return new int[]{rowLeft, rowLeft + singleplayerWidth + 4};
    }

    private void adjustSingleplayerButton(int y, boolean hasQuickload) {
        int singleplayerWidth = hasQuickload ? 196 - this.calculateQuickloadButtonWidth() : 200;
        int[] positions = this.calculateButtonPositions(this.calculateQuickloadButtonWidth());
        this.f_169369_.stream().filter(widget -> widget instanceof Button).map(widget -> (Button)widget).filter(button -> button.m_6035_() != null && button.m_6035_().getString().contains("Singleplayer")).findFirst().ifPresent(button -> {
            button.m_252865_(positions[0]);
            button.m_253211_(y);
            button.m_93674_(singleplayerWidth);
            button.setHeight(20);
        });
    }

    private Optional<LevelSummary> getLastPlayedWorld() {
        try {
            if (this.f_96541_ == null) {
                return Optional.empty();
            }
            LevelStorageSource levelSource = this.f_96541_.m_91392_();
            if (levelSource == null) {
                return Optional.empty();
            }
            LevelStorageSource.LevelCandidates candidates = levelSource.m_230833_();
            if (candidates == null) {
                return Optional.empty();
            }
            return ((List)levelSource.m_230813_(candidates).join()).stream().filter(summary -> !summary.m_78375_()).max(Comparator.comparingLong(LevelSummary::m_78366_));
        }
        catch (Exception e) {
            LOGGER.error("Failed to load world summaries", (Throwable)e);
            return Optional.empty();
        }
    }

    private void loadLastWorld(LevelSummary levelSummary, Button button) {
        if (this.f_96541_ == null || levelSummary == null) {
            LOGGER.error("Cannot load world - minecraft or levelSummary is null");
            this.resetLoadingState(button);
            return;
        }
        try {
            if (levelSummary.m_78375_()) {
                LOGGER.error("World is locked: {}", (Object)levelSummary.m_78358_());
                this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this));
                this.resetLoadingState(button);
                return;
            }
            this.f_96541_.m_91152_(new Screen((Component)Component.m_237115_((String)"selectWorld.loading")){

                protected void m_7856_() {
                }
            });
            try {
                this.f_96541_.m_231466_().m_233133_((Screen)this, levelSummary.m_78358_());
            }
            catch (Exception e) {
                LOGGER.error("Failed to load world: {}", (Object)levelSummary.m_78358_(), (Object)e);
                this.f_96541_.execute(() -> {
                    this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this));
                    this.resetLoadingState(button);
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Critical error loading world: {}", (Object)levelSummary.m_78358_(), (Object)e);
            this.f_96541_.execute(() -> {
                this.f_96541_.m_91152_((Screen)new SelectWorldScreen((Screen)this));
                this.resetLoadingState(button);
            });
        }
    }

    private void resetLoadingState(Button button) {
        this.isLoading.set(false);
        if (button != null) {
            button.f_93623_ = true;
        }
    }
}

