/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecraftalphaargmod.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.minecraftalphaargmod.TheArgContainerMod;
import net.mcreator.minecraftalphaargmod.procedures.FreezerRProcedure;
import net.mcreator.minecraftalphaargmod.world.inventory.FreezerGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class FreezerGUISlotMessage {
    private final int slotID;
    private final int x;
    private final int y;
    private final int z;
    private final int changeType;
    private final int meta;
    private HashMap<String, String> textstate;

    public FreezerGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta, HashMap<String, String> textstate) {
        this.slotID = slotID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.changeType = changeType;
        this.meta = meta;
        this.textstate = textstate;
    }

    public FreezerGUISlotMessage(FriendlyByteBuf buffer) {
        this.slotID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.changeType = buffer.readInt();
        this.meta = buffer.readInt();
        this.textstate = FreezerGUISlotMessage.readTextState(buffer);
    }

    public static void buffer(FreezerGUISlotMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
        FreezerGUISlotMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(FreezerGUISlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int slotID = message.slotID;
            int changeType = message.changeType;
            int meta = message.meta;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            FreezerGUISlotMessage.handleSlotAction((Player)entity, slotID, changeType, meta, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = FreezerGUIMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 2 && changeType == 0) {
            FreezerRProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 0 && changeType == 0) {
            FreezerRProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (slot == 1 && changeType == 0) {
            FreezerRProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheArgContainerMod.addNetworkMessage(FreezerGUISlotMessage.class, FreezerGUISlotMessage::buffer, FreezerGUISlotMessage::new, FreezerGUISlotMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.m_130070_(entry.getValue());
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130277_();
            String value = buffer.m_130277_();
            map.put(key, value);
        }
        return map;
    }
}

