/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecraftalphaargmod.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.minecraftalphaargmod.TheArgContainerMod;
import net.mcreator.minecraftalphaargmod.procedures.SkyBuilderRecipe1Procedure;
import net.mcreator.minecraftalphaargmod.procedures.SkyBuilderRecipe2Procedure;
import net.mcreator.minecraftalphaargmod.procedures.SkyBuilderRecipe3Procedure;
import net.mcreator.minecraftalphaargmod.procedures.SkyBuilderRecipe4Procedure;
import net.mcreator.minecraftalphaargmod.procedures.SkyBuilderRecipe5Procedure;
import net.mcreator.minecraftalphaargmod.procedures.SkyBuilderRecipe6Procedure;
import net.mcreator.minecraftalphaargmod.procedures.SkyBuilderRecipe7Procedure;
import net.mcreator.minecraftalphaargmod.world.inventory.SkyBuilderGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SkyBuilderGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;
    private HashMap<String, String> textstate;

    public SkyBuilderGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.textstate = SkyBuilderGUIButtonMessage.readTextState(buffer);
    }

    public SkyBuilderGUIButtonMessage(int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.textstate = textstate;
    }

    public static void buffer(SkyBuilderGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        SkyBuilderGUIButtonMessage.writeTextState(message.textstate, buffer);
    }

    public static void handler(SkyBuilderGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            HashMap<String, String> textstate = message.textstate;
            SkyBuilderGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z, textstate);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z, HashMap<String, String> textstate) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SkyBuilderGUIMenu.guistate;
        for (Map.Entry<String, String> entry : textstate.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            guistate.put(key, value);
        }
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SkyBuilderRecipe1Procedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            SkyBuilderRecipe2Procedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            SkyBuilderRecipe3Procedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            SkyBuilderRecipe4Procedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SkyBuilderRecipe5Procedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SkyBuilderRecipe6Procedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SkyBuilderRecipe7Procedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheArgContainerMod.addNetworkMessage(SkyBuilderGUIButtonMessage.class, SkyBuilderGUIButtonMessage::buffer, SkyBuilderGUIButtonMessage::new, SkyBuilderGUIButtonMessage::handler);
    }

    public static void writeTextState(HashMap<String, String> map, FriendlyByteBuf buffer) {
        buffer.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.m_130070_(entry.getValue());
        }
    }

    public static HashMap<String, String> readTextState(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            String key = buffer.m_130277_();
            String value = buffer.m_130277_();
            map.put(key, value);
        }
        return map;
    }
}

