/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecraftalphaargmod.procedures;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.DimensionSpecialEffectsManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class RenderRainProcedure {
    private static float partialTick = 0.0f;
    private static int ticks = 0;
    private static final Predicate<Object[]> PREDICATE = params -> {
        ticks = (Integer)params[1];
        partialTick = ((Float)params[2]).floatValue();
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = minecraft.f_91063_.m_109153_().m_90592_();
        if (entity != null) {
            ClientLevel level = minecraft.f_91073_;
            Vec3 pos = entity.m_20318_(partialTick);
            RenderRainProcedure.execute(null, (LevelAccessor)level, (ResourceKey<Level>)level.m_46472_());
            return true;
        }
        return false;
    };

    public static void renderRain(float speed, int x, int z, int range, int color, boolean constant) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Vec3 pos = minecraft.f_91063_.m_109153_().m_90583_();
        double camX = pos.m_7096_();
        double camY = pos.m_7098_();
        double camZ = pos.m_7094_();
        int iCamX = Mth.m_14107_((double)camX);
        int iCamY = Mth.m_14107_((double)camY);
        int iCamZ = Mth.m_14107_((double)camZ);
        int height = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        int length = Minecraft.m_91405_() ? 10 : 5;
        int btm = iCamY - (range > length ? range : length);
        int top = iCamY + (range > length ? range : length);
        if (btm < height) {
            btm = height;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= level.m_46722_(partialTick);
        }
        if (top > height) {
            int idx = x - iCamX;
            int idz = z - iCamZ;
            double r = Mth.m_14116_((float)(idx * idx + idz * idz));
            double vecX = (double)(-idz) / r * 0.5;
            double vecZ = (double)idx / r * 0.5;
            RandomSource randomSource = RandomSource.m_216335_((long)(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761));
            int counts = ticks + x * x * 3121 + x * 45238971 + z * z * 418711 + z * 13761 & 0x1F;
            float anime = -(((float)counts + partialTick) * speed) / 32.0f * (3.0f + randomSource.m_188501_());
            double dx = (double)((float)x + 0.5f) - camX;
            double dz = (double)((float)z + 0.5f) - camZ;
            if (range > 0) {
                float coef = (float)Math.sqrt(dx * dx + dz * dz) / (float)range;
                alpha = (alpha *= (1.0f - coef * coef) * 0.5f + 0.5f) < 0.0f ? 0.0f : alpha;
            }
            int y = iCamY < height ? height : iCamY;
            int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)new BlockPos(x, y, z));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::m_172829_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            bufferBuilder.m_5483_((double)x - camX - vecX + 0.5, (double)top - camY, (double)z - camZ - vecZ + 0.5).m_7421_(0.0f, (float)btm * 0.25f + anime).m_85950_(red, green, blue, alpha).m_85969_(packedLight).m_5752_();
            bufferBuilder.m_5483_((double)x - camX - vecX + 0.5, (double)btm - camY, (double)z - camZ - vecZ + 0.5).m_7421_(0.0f, (float)top * 0.25f + anime).m_85950_(red, green, blue, alpha).m_85969_(packedLight).m_5752_();
            bufferBuilder.m_5483_((double)x - camX + vecX + 0.5, (double)btm - camY, (double)z - camZ + vecZ + 0.5).m_7421_(1.0f, (float)top * 0.25f + anime).m_85950_(red, green, blue, alpha).m_85969_(packedLight).m_5752_();
            bufferBuilder.m_5483_((double)x - camX + vecX + 0.5, (double)top - camY, (double)z - camZ + vecZ + 0.5).m_7421_(1.0f, (float)btm * 0.25f + anime).m_85950_(red, green, blue, alpha).m_85969_(packedLight).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
    }

    public static void renderSnow(float speed, int x, int z, int range, int color, boolean constant) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        Vec3 pos = minecraft.f_91063_.m_109153_().m_90583_();
        double camX = pos.m_7096_();
        double camY = pos.m_7098_();
        double camZ = pos.m_7094_();
        int iCamX = Mth.m_14107_((double)camX);
        int iCamY = Mth.m_14107_((double)camY);
        int iCamZ = Mth.m_14107_((double)camZ);
        int height = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, x, z);
        int length = Minecraft.m_91405_() ? 10 : 5;
        int btm = iCamY - (range > length ? range : length);
        int top = iCamY + (range > length ? range : length);
        if (btm < height) {
            btm = height;
        }
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >>> 24) / 255.0f;
        if (!constant) {
            alpha *= level.m_46722_(partialTick);
        }
        if (top > height) {
            RandomSource randomSource = RandomSource.m_216335_((long)(x * x * 3121 + x * 45238971 ^ z * z * 418711 + z * 13761));
            int idx = x - iCamX;
            int idz = z - iCamZ;
            double r = Mth.m_14116_((float)(idx * idx + idz * idz));
            double vecX = (double)(-idz) / r * 0.5;
            double vecZ = (double)idx / r * 0.5;
            float anime = -((float)(ticks & 0x1FF) + partialTick) / 512.0f;
            float time = (float)ticks + partialTick;
            float du = (float)(randomSource.m_188500_() + randomSource.m_188583_() * (double)time * 0.01) * speed;
            float dv = (float)(randomSource.m_188500_() + randomSource.m_188583_() * (double)time * 0.001) * (speed / 10.0f);
            double dx = (double)((float)x + 0.5f) - camX;
            double dz = (double)((float)z + 0.5f) - camZ;
            if (range > 0) {
                float coef = (float)Math.sqrt(dx * dx + dz * dz) / (float)range;
                alpha = (alpha *= (1.0f - coef * coef) * 0.5f + 0.5f) < 0.0f ? 0.0f : alpha;
            }
            int y = iCamY < height ? height : iCamY;
            int packedLight = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)new BlockPos(x, y, z));
            int sky = ((packedLight & 0xFFFF) * 3 + 240) / 4;
            int block = ((packedLight >> 16 & 0xFFFF) * 3 + 240) / 4;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(GameRenderer::m_172829_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
            bufferBuilder.m_5483_((double)x - camX - vecX + 0.5, (double)top - camY, (double)z - camZ - vecZ + 0.5).m_7421_(0.0f + du, (float)btm * 0.25f + anime + dv).m_85950_(red, green, blue, alpha).m_7120_(sky, block).m_5752_();
            bufferBuilder.m_5483_((double)x - camX - vecX + 0.5, (double)btm - camY, (double)z - camZ - vecZ + 0.5).m_7421_(0.0f + du, (float)top * 0.25f + anime + dv).m_85950_(red, green, blue, alpha).m_7120_(sky, block).m_5752_();
            bufferBuilder.m_5483_((double)x - camX + vecX + 0.5, (double)btm - camY, (double)z - camZ + vecZ + 0.5).m_7421_(1.0f + du, (float)top * 0.25f + anime + dv).m_85950_(red, green, blue, alpha).m_7120_(sky, block).m_5752_();
            bufferBuilder.m_5483_((double)x - camX + vecX + 0.5, (double)top - camY, (double)z - camZ + vecZ + 0.5).m_7421_(1.0f + du, (float)btm * 0.25f + anime + dv).m_85950_(red, green, blue, alpha).m_7120_(sky, block).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
    }

    public static void renderWeather(boolean rain, boolean snow, float speed, int range, int color, boolean constant) {
        if (range > 0) {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            Vec3 pos = minecraft.f_91063_.m_109153_().m_90583_();
            int ix = Mth.m_14107_((double)pos.m_7096_());
            int iy = Mth.m_14107_((double)pos.m_7098_());
            int iz = Mth.m_14107_((double)pos.m_7094_());
            for (int i = -range; i <= range; ++i) {
                for (int j = -range; j <= range; ++j) {
                    BlockPos blockPos = new BlockPos(ix + i, iy, iz + j);
                    Biome biome = (Biome)level.m_204166_(blockPos).m_203334_();
                    if (!biome.m_264473_()) continue;
                    Biome.Precipitation precipitation = biome.m_264600_(blockPos);
                    if (rain && precipitation == Biome.Precipitation.RAIN) {
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/rain.png"));
                        RenderRainProcedure.renderRain(speed, ix + i, iz + j, range, color, constant);
                    }
                    if (!snow || precipitation != Biome.Precipitation.SNOW) continue;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/snow.png"));
                    RenderRainProcedure.renderSnow(speed, ix + i, iz + j, range, color, constant);
                }
            }
        }
    }

    @SubscribeEvent
    public static void weatherSetup(FMLClientSetupEvent event) {
        try {
            Field field = DimensionSpecialEffectsManager.class.getDeclaredField("EFFECTS");
            field.setAccessible(true);
            for (DimensionSpecialEffects dimensionSpecialEffects : ((ImmutableMap)field.get(null)).values()) {
                Class<?> effects = dimensionSpecialEffects.getClass();
                ((Set)effects.getField("CUSTOM_WEATHER").get(null)).add(PREDICATE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void execute(LevelAccessor world, ResourceKey<Level> dimension) {
        RenderRainProcedure.execute(null, world, dimension);
    }

    private static void execute(@Nullable Event event, final LevelAccessor world, ResourceKey<Level> dimension) {
        if (dimension == null) {
            return;
        }
        if (dimension == Level.f_46428_ && world instanceof ClientLevel) {
            BlockPos _renderCenter = Minecraft.m_91087_().f_91063_.m_109153_().m_90588_();
            int _renderLength = Minecraft.m_91405_() ? 10 : 5;
            int _renderRange = Minecraft.m_91405_() ? 10 : 5;
            _renderLength = _renderRange > _renderLength ? _renderRange : _renderLength;
            for (int _renderZ = -_renderRange; _renderZ <= _renderRange; ++_renderZ) {
                for (int _renderX = -_renderRange; _renderX <= _renderRange; ++_renderX) {
                    int positionz;
                    int positionx = _renderCenter.m_123341_() + _renderX;
                    int positiony = world.m_6924_(Heightmap.Types.MOTION_BLOCKING, positionx, positionz = _renderCenter.m_123343_() + _renderZ);
                    if (positiony > _renderCenter.m_123342_() + _renderLength) continue;
                    int n = positiony = positiony < _renderCenter.m_123342_() - _renderLength ? _renderCenter.m_123342_() - _renderLength : positiony;
                    if (new Object(){

                        public boolean is(LevelAccessor levelAccessor, BlockPos blockPos, Biome.Precipitation precipitation) {
                            return ((Biome)world.m_204166_(blockPos).m_203334_()).m_264600_(blockPos) == precipitation;
                        }
                    }.is(world, new BlockPos(positionx, positiony, positionz), Biome.Precipitation.RAIN)) {
                        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/rain.png"));
                        RenderRainProcedure.renderRain(1.0f, positionx, positionz, Minecraft.m_91405_() ? 10 : 5, -1, false);
                        continue;
                    }
                    if (!new Object(){

                        public boolean is(LevelAccessor levelAccessor, BlockPos blockPos, Biome.Precipitation precipitation) {
                            return ((Biome)world.m_204166_(blockPos).m_203334_()).m_264600_(blockPos) == precipitation;
                        }
                    }.is(world, new BlockPos(positionx, positiony, positionz), Biome.Precipitation.SNOW)) continue;
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("minecraft:textures/environment/snow.png"));
                    RenderRainProcedure.renderSnow(1.0f, positionx, positionz, Minecraft.m_91405_() ? 10 : 5, -1, false);
                }
            }
        }
    }
}

