/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minecraftalphaargmod.util;

import net.mcreator.minecraftalphaargmod.configuration.McconfigConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class MoonLookUtil {
    private MoonLookUtil() {
    }

    public static boolean isLookingAtMoon(Player player, float partialTicks, double toleranceDegrees) {
        Vec3 moonTarget;
        boolean hasClock;
        if (player == null) {
            return false;
        }
        if (!((Boolean)McconfigConfiguration.DONT_LOOK_AT_THE_MOON.get()).booleanValue()) {
            return false;
        }
        boolean bl = hasClock = player.m_21205_().m_150930_(Items.f_42524_) || player.m_21206_().m_150930_(Items.f_42524_);
        if (!hasClock) {
            return false;
        }
        Level level = player.m_9236_();
        if (!Level.f_46428_.equals((Object)level.m_46472_())) {
            return false;
        }
        if (level.m_46461_()) {
            return false;
        }
        BlockPos eyePos = BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20188_(), (double)player.m_20189_());
        if (!level.m_45527_(eyePos)) {
            return false;
        }
        if (player.m_21023_(MobEffects.f_19610_) || player.m_21023_(MobEffects.f_216964_)) {
            return false;
        }
        Vec3 moonDir = MoonLookUtil.getMoonDirection(level, partialTicks);
        if (moonDir.f_82480_ <= 0.0) {
            return false;
        }
        Vec3 eyeVec = player.m_20299_(partialTicks);
        BlockHitResult hit = level.m_45547_(new ClipContext(eyeVec, moonTarget = eyeVec.m_82549_(moonDir.m_82490_(300.0)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            return false;
        }
        Vec3 look = player.m_20154_().m_82541_();
        double dot = Mth.m_14008_((double)look.m_82526_(moonDir), (double)-1.0, (double)1.0);
        double angleDeg = Math.toDegrees(Math.acos(dot));
        return angleDeg <= toleranceDegrees;
    }

    public static Vec3 getMoonDirection(Level level, float partialTicks) {
        double a = (double)level.m_46942_(partialTicks) * (Math.PI * 2);
        return new Vec3(Math.sin(a), -Math.cos(a), 0.0).m_82541_();
    }
}

