/*
 * Decompiled with CFR 0.152.
 */
package com.hideplayersbluemap;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.WebApp;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HidePlayersMod
implements ModInitializer {
    public static final String MOD_ID = "hide-players-bluemap";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hide-players-bluemap");
    private final Set<UUID> hiddenPlayers = new HashSet<UUID>();
    private final Map<UUID, Boolean> playerVisibilityPreferences = new HashMap<UUID, Boolean>();
    private boolean blueMapEnabled = false;
    private File configFile;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private boolean defaultVisible = false;

    public void onInitialize() {
        LOGGER.info("Initializing Hide Players BlueMap mod");
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.registerCommands((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.configFile = server.method_3831().resolve("config").resolve("hide-players-bluemap.json").toFile();
            this.loadPreferences();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.savePreferences());
        BlueMapAPI.onEnable(this::onBlueMapEnable);
        BlueMapAPI.onDisable(this::onBlueMapDisable);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            UUID uuid = player.method_5667();
            if (!this.playerVisibilityPreferences.containsKey(uuid)) {
                this.playerVisibilityPreferences.put(uuid, this.defaultVisible);
                String status = this.defaultVisible ? "VISIBLE" : "HIDDEN";
                LOGGER.info("Player {} joined - default visibility set to {}", (Object)player.method_5477().getString(), (Object)status);
            }
            this.applyPlayerVisibility(uuid);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % 100 == 0 && this.blueMapEnabled) {
                for (class_3222 player : server.method_3760().method_14571()) {
                    this.applyPlayerVisibility(player.method_5667());
                }
            }
        });
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bmpv").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"hide").executes(this::hidePlayerCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(source -> source.method_9259(2))).executes(this::hideOtherPlayerCommand)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"show").executes(this::showPlayerCommand)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).requires(source -> source.method_9259(2))).executes(this::showOtherPlayerCommand)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"default").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"hide").executes(this::setDefaultHideCommand))).then(class_2170.method_9247((String)"show").executes(this::setDefaultShowCommand)))).executes(this::statusCommand));
    }

    private int hidePlayerCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_44023() == null) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"), false);
            return 0;
        }
        class_3222 player = source.method_44023();
        UUID uuid = player.method_5667();
        this.playerVisibilityPreferences.put(uuid, false);
        this.applyPlayerVisibility(uuid);
        this.savePreferences();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7aYou are now \u00a7cHIDDEN \u00a7aon the BlueMap!"), false);
        LOGGER.info("Player {} set their visibility to HIDDEN", (Object)player.method_5477().getString());
        return 1;
    }

    private int showPlayerCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_44023() == null) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"), false);
            return 0;
        }
        class_3222 player = source.method_44023();
        UUID uuid = player.method_5667();
        this.playerVisibilityPreferences.put(uuid, true);
        this.applyPlayerVisibility(uuid);
        this.savePreferences();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7aYou are now \u00a72VISIBLE \u00a7aon the BlueMap!"), false);
        LOGGER.info("Player {} set their visibility to VISIBLE", (Object)player.method_5477().getString());
        return 1;
    }

    private int hideOtherPlayerCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            Collection targetPlayers = class_2186.method_9312(context, (String)"targets");
            int count = 0;
            for (class_3222 targetPlayer : targetPlayers) {
                UUID uuid = targetPlayer.method_5667();
                this.playerVisibilityPreferences.put(uuid, false);
                this.applyPlayerVisibility(uuid);
                ++count;
            }
            this.savePreferences();
            if (count == 1) {
                class_3222 singlePlayer = (class_3222)targetPlayers.iterator().next();
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7aPlayer \u00a7e" + singlePlayer.method_5477().getString() + " \u00a7ais now \u00a7cHIDDEN \u00a7aon the BlueMap!")), false);
                LOGGER.info("Operator {} set player {}'s visibility to HIDDEN", (Object)source.method_9214(), (Object)singlePlayer.method_5477().getString());
            } else {
                int finalCount = count;
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7a" + finalCount + " player(s) are now \u00a7cHIDDEN \u00a7aon the BlueMap!")), false);
                LOGGER.info("Operator {} set {} player(s) visibility to HIDDEN", (Object)source.method_9214(), (Object)finalCount);
            }
            return count;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cNo players found!"));
            return 0;
        }
    }

    private int showOtherPlayerCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        try {
            Collection targetPlayers = class_2186.method_9312(context, (String)"targets");
            int count = 0;
            for (class_3222 targetPlayer : targetPlayers) {
                UUID uuid = targetPlayer.method_5667();
                this.playerVisibilityPreferences.put(uuid, true);
                this.applyPlayerVisibility(uuid);
                ++count;
            }
            this.savePreferences();
            if (count == 1) {
                class_3222 singlePlayer = (class_3222)targetPlayers.iterator().next();
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7aPlayer \u00a7e" + singlePlayer.method_5477().getString() + " \u00a7ais now \u00a72VISIBLE \u00a7aon the BlueMap!")), false);
                LOGGER.info("Operator {} set player {}'s visibility to VISIBLE", (Object)source.method_9214(), (Object)singlePlayer.method_5477().getString());
            } else {
                int finalCount = count;
                source.method_9226(() -> class_2561.method_43470((String)("\u00a7a" + finalCount + " player(s) are now \u00a72VISIBLE \u00a7aon the BlueMap!")), false);
                LOGGER.info("Operator {} set {} player(s) visibility to VISIBLE", (Object)source.method_9214(), (Object)finalCount);
            }
            return count;
        }
        catch (CommandSyntaxException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cPlayer not found!"));
            return 0;
        }
    }

    private int setDefaultHideCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        this.defaultVisible = false;
        this.savePreferences();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7aDefault visibility set to \u00a7cHIDDEN\u00a7a. New players will be hidden on BlueMap by default."), false);
        LOGGER.info("Operator {} set default visibility to HIDDEN", (Object)source.method_9214());
        return 1;
    }

    private int setDefaultShowCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        this.defaultVisible = true;
        this.savePreferences();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7aDefault visibility set to \u00a72VISIBLE\u00a7a. New players will be visible on BlueMap by default."), false);
        LOGGER.info("Operator {} set default visibility to VISIBLE", (Object)source.method_9214());
        return 1;
    }

    private int statusCommand(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_44023() == null) {
            source.method_9226(() -> class_2561.method_43470((String)"\u00a7cThis command can only be used by players!"), false);
            return 0;
        }
        class_3222 player = source.method_44023();
        UUID uuid = player.method_5667();
        boolean visible = this.playerVisibilityPreferences.getOrDefault(uuid, false);
        String status = visible ? "\u00a72VISIBLE" : "\u00a7cHIDDEN";
        source.method_9226(() -> class_2561.method_43470((String)("\u00a77Your current BlueMap visibility: " + status)), false);
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77Use \u00a7e/bmpv hide\u00a77 or \u00a7e/bmpv show\u00a77 to change"), false);
        return 1;
    }

    private void onBlueMapEnable(BlueMapAPI api) {
        LOGGER.info("BlueMap API enabled - applying player visibility preferences");
        this.blueMapEnabled = true;
        BlueMapAPI.getInstance().ifPresent(blueMapAPI -> {
            WebApp webApp = api.getWebApp();
            if (this.playerVisibilityPreferences.isEmpty()) {
                LOGGER.info("No player visibility preferences set yet");
                return;
            }
            int hiddenCount = 0;
            int visibleCount = 0;
            LOGGER.info("========================================");
            LOGGER.info("Applying visibility for {} player(s)", (Object)this.playerVisibilityPreferences.size());
            for (Map.Entry<UUID, Boolean> entry : this.playerVisibilityPreferences.entrySet()) {
                UUID uuid = entry.getKey();
                boolean visible = entry.getValue();
                webApp.setPlayerVisibility(uuid, visible);
                if (visible) {
                    ++visibleCount;
                    LOGGER.info("Set player {} to VISIBLE", (Object)uuid);
                    continue;
                }
                ++hiddenCount;
                LOGGER.info("Set player {} to HIDDEN", (Object)uuid);
            }
            LOGGER.info("========================================");
            LOGGER.info("Summary: {} hidden, {} visible", (Object)hiddenCount, (Object)visibleCount);
            LOGGER.info("========================================");
        });
    }

    private void onBlueMapDisable(BlueMapAPI api) {
        LOGGER.info("BlueMap API disabled");
        this.blueMapEnabled = false;
    }

    private void applyPlayerVisibility(UUID playerUuid) {
        boolean visible = this.playerVisibilityPreferences.getOrDefault(playerUuid, false);
        if (!visible) {
            this.hiddenPlayers.add(playerUuid);
        } else {
            this.hiddenPlayers.remove(playerUuid);
        }
        if (this.blueMapEnabled) {
            BlueMapAPI.getInstance().ifPresent(api -> {
                WebApp webApp = api.getWebApp();
                webApp.setPlayerVisibility(playerUuid, visible);
                LOGGER.debug("Applied visibility {} for player: {}", (Object)(visible ? "VISIBLE" : "HIDDEN"), (Object)playerUuid);
            });
        }
    }

    private void savePreferences() {
        if (this.configFile == null) {
            LOGGER.warn("Config file not initialized, cannot save preferences");
            return;
        }
        try {
            File configDir = this.configFile.getParentFile();
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            HashMap serializablePrefs = new HashMap();
            this.playerVisibilityPreferences.forEach((uuid, visible) -> serializablePrefs.put(uuid.toString(), visible));
            HashMap<String, Serializable> config = new HashMap<String, Serializable>();
            config.put("defaultVisible", Boolean.valueOf(this.defaultVisible));
            config.put("playerPreferences", serializablePrefs);
            try (FileWriter writer = new FileWriter(this.configFile);){
                this.gson.toJson(config, (Appendable)writer);
            }
            LOGGER.info("Saved visibility preferences for {} players (default: {})", (Object)serializablePrefs.size(), (Object)(this.defaultVisible ? "VISIBLE" : "HIDDEN"));
        }
        catch (IOException e) {
            LOGGER.error("Failed to save player visibility preferences", (Throwable)e);
        }
    }

    private void loadPreferences() {
        if (this.configFile == null || !this.configFile.exists()) {
            LOGGER.info("No saved preferences found, using defaults (defaultVisible: {})", (Object)this.defaultVisible);
            return;
        }
        try (FileReader reader = new FileReader(this.configFile);){
            Type type = new TypeToken<Map<String, Object>>(this){}.getType();
            Map config = (Map)this.gson.fromJson((Reader)reader, type);
            if (config != null) {
                Map loadedPrefs;
                if (config.containsKey("defaultVisible")) {
                    this.defaultVisible = (Boolean)config.get("defaultVisible");
                }
                if (config.containsKey("playerPreferences") && (loadedPrefs = (Map)config.get("playerPreferences")) != null) {
                    this.playerVisibilityPreferences.clear();
                    loadedPrefs.forEach((uuidStr, visible) -> {
                        try {
                            UUID uuid = UUID.fromString(uuidStr);
                            this.playerVisibilityPreferences.put(uuid, (Boolean)visible);
                        }
                        catch (IllegalArgumentException e) {
                            LOGGER.warn("Invalid UUID in config file: {}", uuidStr);
                        }
                    });
                }
                LOGGER.info("Loaded visibility preferences for {} players (default: {})", (Object)this.playerVisibilityPreferences.size(), (Object)(this.defaultVisible ? "VISIBLE" : "HIDDEN"));
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load player visibility preferences", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.warn("Old config format detected, attempting migration...");
            try (FileReader reader2 = new FileReader(this.configFile);){
                Type type = new TypeToken<Map<String, Boolean>>(this){}.getType();
                Map loadedPrefs = (Map)this.gson.fromJson((Reader)reader2, type);
                if (loadedPrefs != null) {
                    this.playerVisibilityPreferences.clear();
                    loadedPrefs.forEach((uuidStr, visible) -> {
                        try {
                            UUID uuid = UUID.fromString(uuidStr);
                            this.playerVisibilityPreferences.put(uuid, (Boolean)visible);
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.warn("Invalid UUID in config file: {}", uuidStr);
                        }
                    });
                    LOGGER.info("Migrated {} player preferences from old format", (Object)this.playerVisibilityPreferences.size());
                    this.savePreferences();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to migrate old config format", (Throwable)ex);
            }
        }
    }
}

