/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore.commands;

import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.pablito.pBLobbyCore.PBLobbyCore;
import org.pablito.pBLobbyCore.commands.ReloadManager;
import org.pablito.pBLobbyCore.utils.MessageManager;

public class PBLobbyCoreCommand
implements CommandExecutor {
    private final PBLobbyCore plugin;
    private final MessageManager messageManager;
    private final ReloadManager reloadManager;

    public PBLobbyCoreCommand(PBLobbyCore plugin, MessageManager messageManager) {
        this.plugin = plugin;
        this.messageManager = messageManager;
        this.reloadManager = new ReloadManager(plugin, messageManager);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.messageManager.getMessage("command-usage"));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("pblcore.admin")) {
                sender.sendMessage(this.messageManager.getMessage("permission-denied"));
                return true;
            }
            this.reloadManager.reloadPlugin();
            sender.sendMessage(this.messageManager.getMessage("plugin-reloaded"));
            return true;
        }
        if (args[0].equalsIgnoreCase("setspawn")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.messageManager.getMessage("no-console-command"));
                return true;
            }
            if (!sender.hasPermission("pblcore.admin")) {
                sender.sendMessage(this.messageManager.getMessage("permission-denied"));
                return true;
            }
            Player player = (Player)sender;
            this.plugin.saveSpawnLocation(player.getLocation());
            player.sendMessage(this.messageManager.getMessage("spawn-set"));
            return true;
        }
        sender.sendMessage(this.messageManager.getMessage("command-usage"));
        return true;
    }
}

