/*
 * Decompiled with CFR 0.152.
 */
package org.pablito.pBLobbyCore.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.pablito.pBLobbyCore.PBLobbyCore;

public class PBLobbyCoreTabCompleter
implements TabCompleter {
    private final PBLobbyCore plugin;
    private static final List<String> MAIN_COMMANDS = List.of("reload", "setspawn", "alt");
    private static final List<String> ALT_SUBCOMMANDS = List.of("add", "remove");

    public PBLobbyCoreTabCompleter(PBLobbyCore plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("pblcore.admin")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[0], MAIN_COMMANDS, completions);
            Collections.sort(completions);
            return completions;
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("alt")) {
            ArrayList<String> completions = new ArrayList<String>();
            StringUtil.copyPartialMatches((String)args[1], ALT_SUBCOMMANDS, completions);
            Collections.sort(completions);
            return completions;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("alt")) {
            ArrayList<String> completions = new ArrayList<String>();
            String subCommand = args[1];
            if (subCommand.equalsIgnoreCase("add")) {
                ArrayList<String> ipAddresses = new ArrayList<String>();
                for (Player player : this.plugin.getServer().getOnlinePlayers()) {
                    if (player.getAddress() == null) continue;
                    String ip = player.getAddress().getAddress().getHostAddress();
                    ipAddresses.add(ip);
                }
                StringUtil.copyPartialMatches((String)args[2], ipAddresses, completions);
            } else if (subCommand.equalsIgnoreCase("remove")) {
                List exceptions = this.plugin.getConfig().getStringList("alt-ip-exceptions");
                StringUtil.copyPartialMatches((String)args[2], (Iterable)exceptions, completions);
            }
            Collections.sort(completions);
            return completions;
        }
        return Collections.emptyList();
    }
}

